/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ImportedExportedDefaultBindingStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ES6ImportedExportedDefaultBindingImpl<StubT extends ES6ImportedExportedDefaultBindingStub<?>>
extends JSStubElementImpl<StubT>
implements StubBasedPsiElement<StubT>,
ES6ImportedExportedDefaultBinding {
    public ES6ImportedExportedDefaultBindingImpl(ASTNode node) {
        super(node);
    }

    public ES6ImportedExportedDefaultBindingImpl(StubT t, IStubElementType type) {
        super(t, type);
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return ES6ImportedExportedDefaultBindingImpl.findNameIdentifier(this.getNode());
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode identifier = this.findNameIdentifier();
        return identifier != null ? identifier.getPsi() : null;
    }

    public String getName() {
        ES6ImportedExportedDefaultBindingStub stub = (ES6ImportedExportedDefaultBindingStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode identifier = this.findNameIdentifier();
        return identifier != null ? identifier.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedExportedDefaultBindingImpl", "setName"));
        }
        ASTNode nameIdentifier = this.findNameIdentifier();
        if (nameIdentifier != null) {
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, JSChangeUtil.createNameIdentifier(this.getProject(), name));
        }
        return this;
    }

    public static ASTNode findNameIdentifier(@NotNull ASTNode importedBindingNode) {
        ASTNode lastChild;
        if (importedBindingNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedBindingNode", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedExportedDefaultBindingImpl", "findNameIdentifier"));
        }
        for (lastChild = importedBindingNode.getLastChildNode(); lastChild != null && !JSKeywordSets.ES6_IDENTIFIER_TOKENS_SET.contains(lastChild.getElementType()); lastChild = lastChild.getTreePrev()) {
        }
        return lastChild;
    }

    @NotNull
    public Collection<PsiElement> findReferencedElements() {
        PsiElement parent = this.getParent();
        if (!(parent instanceof ES6ImportExportDeclaration)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedExportedDefaultBindingImpl", "findReferencedElements"));
            }
            return list;
        }
        ES6FromClause fromClause = ((ES6ImportExportDeclaration)parent).getFromClause();
        if (fromClause == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedExportedDefaultBindingImpl", "findReferencedElements"));
            }
            return list;
        }
        Collection elements = fromClause.resolveReferencedElements();
        SmartList result = new SmartList();
        if (elements.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedExportedDefaultBindingImpl", "findReferencedElements"));
            }
            return list;
        }
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)this);
        for (PsiElement element : elements) {
            if (element instanceof JSElement) {
                JSElement export = ES6PsiUtil.findDefaultExport((JSElement)element);
                if (export != null) {
                    result.add((Object)export);
                } else {
                    TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
                    if (assignment != null) {
                        result.add((Object)assignment);
                    } else if (isTypeScript && ES6PsiUtil.isExternalModule(element) && (!(element instanceof TypeScriptModule) || !((TypeScriptModule)element).isAugmentation())) {
                        result.add((Object)element);
                    }
                }
            }
            if (!(element instanceof JSFile) || !((JSFile)element).isCommonJSModule() || ((JSFile)element).hasES6Syntax() || isTypeScript) continue;
            result.add((Object)element);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportedExportedDefaultBindingImpl", "findReferencedElements"));
        }
        return smartList;
    }

    @Nullable
    public ES6ImportExportDeclaration getDeclaration() {
        ES6ImportedExportedDefaultBindingStub stub = (ES6ImportedExportedDefaultBindingStub)this.getGreenStub();
        if (stub != null) {
            return (ES6ImportExportDeclaration)stub.getParentStubOfType(ES6ImportExportDeclaration.class);
        }
        return (ES6ImportExportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this, ES6ImportExportDeclaration.class);
    }
}

