/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionCompletionContributor
extends CompletionContributor {
    private final boolean isUnitTest;
    public static final Key<Boolean> TEST_MARKER = new Key("JSFunctionCompletionContributor.tests.marker");
    private static final InsertHandler<LookupElement> FUNCTION_EXPRESSION_INSERT_HANDLER = (context, item) -> {
        String lookupString = item.getLookupString();
        int lBraceIndex = lookupString.indexOf(123);
        if (lBraceIndex < 0) {
            return;
        }
        int caretPosition = lBraceIndex + (lBraceIndex < lookupString.length() - 1 && Character.isWhitespace(lookupString.charAt(lBraceIndex + 1)) ? 2 : 1);
        if (caretPosition < lookupString.length()) {
            CaretModel caretModel = context.getEditor().getCaretModel();
            caretModel.moveToOffset(caretModel.getOffset() - lookupString.length() + caretPosition);
        }
    };

    public JSFunctionCompletionContributor(Application application) {
        this.isUnitTest = application.isUnitTestMode();
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        JSExpression jsElement;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "fillCompletionVariants"));
        }
        super.fillCompletionVariants(parameters, result);
        PsiElement parent = JSUtils.getParentSkipParentheses(parameters.getPosition());
        JSExpression jSExpression = jsElement = parent instanceof JSExpression ? (JSExpression)parent : null;
        if (jsElement == null) {
            return;
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType(jsElement);
        if (expectedType == null || !expectedType.getSource().isExplicitlyDeclared()) {
            return;
        }
        JSFunctionTypeImpl jsFunctionType = JSFunctionCompletionContributor.getFunctionTypeOrNull(expectedType);
        if (jsFunctionType == null) {
            return;
        }
        CommonCodeStyleSettings commonSettings = JSCodeStyleSettings.getCommonSettings(parameters.getPosition());
        JSCodeStyleSettings jsCodeStyleSettings = JSCodeStyleSettings.getSettings(parameters.getPosition());
        DialectOptionHolder dialect = (DialectOptionHolder)ObjectUtils.assertNotNull((Object)DialectDetector.dialectOfElement(parameters.getPosition()));
        List<String> parameterNames = JSFunctionCompletionContributor.getParameterNames(jsFunctionType, parent);
        if (dialect.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS)) {
            String signature = JSFunctionCompletionContributor.getLambdaSignature(parameterNames, jsCodeStyleSettings);
            result.addElement(this.createLookupElement(signature, (Function<LookupElementBuilder, LookupElementBuilder>)((Function)builder -> builder.withPresentableText(builder.getLookupString() + "{}"))));
        } else {
            result.addElement(this.createLookupElement(JSFunctionCompletionContributor.getAnonymousFunctionSignature(parameterNames, commonSettings, jsCodeStyleSettings), (Function<LookupElementBuilder, LookupElementBuilder>)((Function)builder -> builder.withInsertHandler(FUNCTION_EXPRESSION_INSERT_HANDLER))));
        }
    }

    @Nullable
    private static JSFunctionTypeImpl getFunctionTypeOrNull(@Nullable JSType expectedType) {
        JSGenericTypeImpl genericType;
        List functionTypes = JSTypeUtils.getFunctionType(expectedType, false).collect(Collectors.toList());
        JSType functionType = (JSType)ContainerUtil.getFirstItem(functionTypes);
        if (functionType == null) {
            return null;
        }
        JSGenericTypeImpl jSGenericTypeImpl = genericType = functionType instanceof JSGenericTypeImpl ? (JSGenericTypeImpl)functionType : null;
        if (genericType != null) {
            functionType = genericType.getType();
        }
        return functionType instanceof JSFunctionTypeImpl ? (JSFunctionTypeImpl)functionType : null;
    }

    @NotNull
    private static List<String> getParameterNames(@NotNull JSFunctionTypeImpl jsFunctionType, @NotNull PsiElement scope) {
        if (jsFunctionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFunctionType", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getParameterNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getParameterNames"));
        }
        List list = ContainerUtil.map(jsFunctionType.getParametersWithName(), pair -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "lambda$getParameterNames$3"));
            }
            return BasicIntroducedEntityInfoProvider.generateUniqueVariableName((String)pair.first, scope, ContainerUtil.emptyList(), false);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getParameterNames"));
        }
        return list;
    }

    @NotNull
    private LookupElement createLookupElement(@NotNull String signature, @Nullable Function<LookupElementBuilder, LookupElementBuilder> configureBuilder) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "createLookupElement"));
        }
        LookupElementBuilder elementBuilder = LookupElementBuilder.create((String)signature);
        elementBuilder = configureBuilder != null ? (LookupElementBuilder)configureBuilder.fun((Object)elementBuilder) : elementBuilder;
        LookupElement element = JSCompletionUtil.withJSLookupPriority((LookupElement)elementBuilder, JSLookupPriority.SMART_PRIORITY);
        if (this.isUnitTest) {
            element.putUserData(TEST_MARKER, (Object)true);
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "createLookupElement"));
        }
        return lookupElement;
    }

    @NotNull
    private static String getAnonymousFunctionSignature(@NotNull List<String> parameterNames, @NotNull CommonCodeStyleSettings commonCodeStyleSettings, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (parameterNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterNames", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getAnonymousFunctionSignature"));
        }
        if (commonCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonCodeStyleSettings", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getAnonymousFunctionSignature"));
        }
        if (jsCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeStyleSettings", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getAnonymousFunctionSignature"));
        }
        StringBuilder builder = new StringBuilder("function");
        if (jsCodeStyleSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH) {
            builder.append(' ');
        }
        builder.append('(');
        String separator = commonCodeStyleSettings.SPACE_AFTER_COMMA ? ", " : ",";
        String parametersStr = StringUtil.join(parameterNames, (String)separator);
        builder.append(parametersStr);
        builder.append(')');
        if (commonCodeStyleSettings.SPACE_BEFORE_METHOD_LBRACE) {
            builder.append(' ');
        }
        builder.append("{  }");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getAnonymousFunctionSignature"));
        }
        return string;
    }

    @NotNull
    private static String getLambdaSignature(@NotNull List<String> parameterNames, @NotNull JSCodeStyleSettings codeStyleSettings) {
        if (parameterNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterNames", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getLambdaSignature"));
        }
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyleSettings", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getLambdaSignature"));
        }
        String parametersStr = StringUtil.join(parameterNames, (String)", ");
        StringBuilder builder = new StringBuilder();
        if (parameterNames.size() != 1) {
            builder.append('(');
        }
        builder.append(parametersStr);
        if (parameterNames.size() != 1) {
            builder.append(')');
        }
        builder.append(codeStyleSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR ? " => " : "=>");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor", "getLambdaSignature"));
        }
        return string;
    }
}

