/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSExternalAnnotator;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlowJSCoverageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/flow/FlowJSCoverageInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitFile(PsiFile file) {
                VirtualFile virtualFile;
                Document document;
                Project project = file.getProject();
                FlowJSServerService serverService = FlowJSServerService.getService(project);
                if (serverService == null) {
                    return;
                }
                FlowJSConfigService configService = FlowJSConfigService.getService(project);
                if (configService == null) {
                    return;
                }
                if (!FlowJSAnnotation.isFlowAnnotation(file)) {
                    return;
                }
                Collection<FlowJSConfig> configsOfFile = configService.getConfigOfFile(file.getVirtualFile());
                if (configsOfFile.isEmpty()) {
                    return;
                }
                FlowJSConfig nearestConfig = (FlowJSConfig)ContainerUtil.getFirstItem(configsOfFile);
                assert (nearestConfig != null);
                List<JSAnnotationError> errors = serverService.getCoverageOfFile(nearestConfig, file);
                if (!errors.isEmpty() && (document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) != null && (virtualFile = file.getVirtualFile()) != null) {
                    FlowJSExternalAnnotator.reportErrors(errors, virtualFile, file, document, null, holder, null);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSCoverageInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }
}

