/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.flowconfig;

import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSConfigImpl
implements FlowJSConfig {
    @NotNull
    private final VirtualFile myConfigDir;
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final Collection<String> myIncludedPatterns;
    @NotNull
    private final Collection<String> myIgnoredPatterns;
    @NotNull
    private final Collection<String> tags;
    private final NullableLazyValue<Pattern> myIncludedRegPattern;
    private final NullableLazyValue<Pattern> myIgnoredRegPattern;

    @Nullable
    public static FlowJSConfig getConfig(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "getConfig"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile configFile = psiFile.getVirtualFile();
        if (configFile == null) {
            return null;
        }
        VirtualFile configDir = configFile.getParent();
        if (configDir == null) {
            return null;
        }
        return new FlowJSConfigImpl(configFile, configDir);
    }

    @NotNull
    private Collection<String> getIgnoredPatterns() {
        Collection<String> collection = this.getPatterns("ignore");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "getIgnoredPatterns"));
        }
        return collection;
    }

    @NotNull
    private Collection<String> getIncludedPatterns() {
        Collection<String> collection = this.getPatterns("include");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "getIncludedPatterns"));
        }
        return collection;
    }

    private static boolean isCommentLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "isCommentLine"));
        }
        boolean isComment = false;
        String lineWithoutWhiteSpaces = line.trim();
        if (lineWithoutWhiteSpaces.charAt(0) == '#') {
            isComment = true;
        }
        return isComment;
    }

    @NotNull
    private static ArrayList<String> removeEmptyLines(@NotNull String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringArray", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "removeEmptyLines"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (String line : stringArray) {
            String newLine = line.trim();
            if (newLine.isEmpty()) continue;
            result.add(newLine);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "removeEmptyLines"));
        }
        return arrayList;
    }

    private Collection<String> getPatterns(@NotNull String requiredTag) {
        if (requiredTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredTag", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "getPatterns"));
        }
        Document configDocument = FileDocumentManager.getInstance().getDocument(this.myConfigFile);
        HashSet myTags = ContainerUtil.newHashSet();
        myTags.addAll(this.tags);
        myTags.remove(requiredTag);
        ArrayList collection = ContainerUtil.newArrayList();
        if (configDocument != null && configDocument.getLineCount() > 0) {
            String text = configDocument.getText();
            boolean isStart = false;
            String[] textLines = text.split("\n");
            ArrayList<String> textWithoutEmptyLines = FlowJSConfigImpl.removeEmptyLines(textLines);
            for (String line : textWithoutEmptyLines) {
                if (!isStart) {
                    if (!line.contains("[" + requiredTag + "]")) continue;
                    isStart = true;
                    continue;
                }
                boolean isAnotherTag = false;
                for (String tag : myTags) {
                    if (!line.contains("[" + tag + "]")) continue;
                    isAnotherTag = true;
                }
                if (isAnotherTag) break;
                if (FlowJSConfigImpl.isCommentLine(line)) continue;
                collection.add(line);
            }
        }
        return collection;
    }

    @Nullable
    private static Pattern createPattern(@Nullable String pattern) {
        if (pattern == null) {
            return null;
        }
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            Logger.getInstance(FlowJSConfigImpl.class).warn("Bad pattern in .flowconfig: " + pattern);
            return null;
        }
    }

    private FlowJSConfigImpl(@NotNull VirtualFile configFile, @NotNull VirtualFile configDir) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "<init>"));
        }
        if (configDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configDir", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "<init>"));
        }
        this.myIncludedRegPattern = new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                if (FlowJSConfigImpl.this.myIncludedPatterns.isEmpty()) {
                    return null;
                }
                String pattern = FlowJSConfigUtil.getRegularExpressionForGlobPattern(FlowJSConfigImpl.this.myIncludedPatterns, FlowJSConfigImpl.this.myConfigDir);
                return FlowJSConfigImpl.createPattern(pattern);
            }
        };
        this.myIgnoredRegPattern = new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                if (FlowJSConfigImpl.this.myIgnoredPatterns.isEmpty()) {
                    return null;
                }
                String pattern = FlowJSConfigUtil.getRegularExpression(FlowJSConfigImpl.this.myIgnoredPatterns, FlowJSConfigImpl.this.myConfigDir);
                return FlowJSConfigImpl.createPattern(pattern);
            }
        };
        this.myConfigDir = configDir;
        this.myConfigFile = configFile;
        this.tags = ContainerUtil.newHashSet();
        FlowJSConfigImpl.createTags(this.tags);
        this.myIncludedPatterns = this.getIncludedPatterns();
        this.myIgnoredPatterns = this.getIgnoredPatterns();
    }

    private static void createTags(@NotNull Collection<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "createTags"));
        }
        set.add("ignore");
        set.add("include");
        set.add("version");
        set.add("options");
        set.add("libs");
    }

    @Override
    public boolean isFileIncluded(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "isFileIncluded"));
        }
        String path = file.getCanonicalPath();
        Pattern pattern = (Pattern)this.myIncludedRegPattern.getValue();
        return VfsUtilCore.isAncestor((VirtualFile)this.getConfigDirectory(), (VirtualFile)file, (boolean)false) || pattern != null && FlowJSConfigImpl.checkPattern(path, pattern);
    }

    @Override
    public boolean isFileIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "isFileIgnored"));
        }
        String path = file.getCanonicalPath();
        if (this.myIgnoredPatterns.isEmpty()) {
            return false;
        }
        Pattern pattern = (Pattern)this.myIgnoredRegPattern.getValue();
        if (pattern == null) {
            return false;
        }
        return FlowJSConfigImpl.checkPattern(path, pattern);
    }

    private static boolean checkPattern(@NotNull String path, @NotNull Pattern pattern) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "checkPattern"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "checkPattern"));
        }
        Matcher m = pattern.matcher(path);
        return m.find();
    }

    @Override
    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "getConfigFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getConfigDirectory() {
        VirtualFile virtualFile = this.myConfigDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl", "getConfigDirectory"));
        }
        return virtualFile;
    }
}

