/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.JavascriptFormattingModelBuilder;
import com.intellij.lang.javascript.formatter.blocks.JSSpacingStrategy;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.CompositeAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSBinaryOperatorAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSDefaultParameterValueAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSPropertyAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSVarStatementAlignmentFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.webcore.formatter.SpacingStrategy;
import com.intellij.webcore.formatter.chainedMethods.CallChainBlockBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBlock
implements ASTBlock {
    @NotNull
    protected final ASTNode myNode;
    @NotNull
    protected final CodeStyleSettings mySettings;
    @NotNull
    private final JSCodeStyleSettings myJSCodeStyleSettings;
    private XmlFormattingPolicy myPolicy;
    @Nullable
    private Alignment myAlignment;
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final Wrap myWrap;
    private List<Block> mySubBlocks;
    protected final Language myDialect;
    protected final ASTNodeBasedAlignmentFactory mySharedAlignmentFactory;
    private final SpacingStrategy mySpacingStrategy;
    private Wrap myChildWrap;

    public JSBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull CodeStyleSettings settings) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "<init>"));
        }
        this(node, alignment, indent, wrap, settings, null, (Language)JavascriptLanguage.INSTANCE, (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class));
    }

    public JSBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull CodeStyleSettings settings, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, Language dialect, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "<init>"));
        }
        if (jsCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeStyleSettings", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "<init>"));
        }
        this.mySubBlocks = null;
        this.myAlignment = alignment;
        this.myIndent = indent;
        this.myNode = node;
        this.myWrap = wrap;
        this.mySettings = settings;
        this.myDialect = dialect;
        this.mySharedAlignmentFactory = this.getSharedAlignmentFactory(sharedAlignmentFactory, jsCodeStyleSettings);
        this.mySpacingStrategy = new JSSpacingStrategy(jsCodeStyleSettings, settings.getCommonSettings(dialect), this::calculateSpacing);
        this.myJSCodeStyleSettings = jsCodeStyleSettings;
    }

    protected Spacing calculateSpacing(ASTNode child1, ASTNode child2) {
        return new JSSpacingProcessor(this.myNode, child1, child2, this.mySettings, this.myDialect, this.myJSCodeStyleSettings).calcSpacing();
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getNode"));
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlocks = this.buildChainBlocks();
            if (this.mySubBlocks == null) {
                SubBlockVisitor visitor = this.createSubBlockVisitor();
                visitor.visit(this.myNode);
                this.mySubBlocks = visitor.getBlocks();
            }
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getSubBlocks"));
        }
        return list;
    }

    protected SubBlockVisitor createSubBlockVisitor() {
        return new SubBlockVisitor(this, this.getSettings(), this.myDialect, this.mySharedAlignmentFactory, this.myJSCodeStyleSettings);
    }

    @Nullable
    private List<Block> buildChainBlocks() {
        if (this.isChainedCallsFormattingSupported() && (this.myNode.getElementType() == JSElementTypes.CALL_EXPRESSION || JSElementTypes.NEW_EXPRESSIONS.contains(this.myNode.getElementType()))) {
            CommonCodeStyleSettings commonJsSettings = this.mySettings.getCommonSettings(this.myDialect);
            final JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)this.mySettings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(this.myDialect));
            CallChainBlockBuilder builder = new CallChainBlockBuilder(this.myNode, this.mySpacingStrategy, jsSettings.INDENT_CHAINED_CALLS ? Indent.Type.CONTINUATION : Indent.Type.NONE, commonJsSettings.METHOD_CALL_CHAIN_WRAP, commonJsSettings.CALL_PARAMETERS_WRAP, commonJsSettings.PREFER_PARAMETERS_WRAP, commonJsSettings.ALIGN_MULTILINE_CHAINED_METHODS, commonJsSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS, jsSettings.CHAINED_CALL_DOT_ON_NEW_LINE, jsSettings.USE_CHAINED_CALLS_GROUP_INDENTS){
                private final JavascriptFormattingModelBuilder builder;
                {
                    super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
                    this.builder = (JavascriptFormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(JSBlock.this.myDialect);
                }

                protected boolean shouldFlatten(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/formatter/blocks/JSBlock$1", "shouldFlatten"));
                    }
                    return elementType == JSElementTypes.REFERENCE_EXPRESSION || elementType == JSElementTypes.CALL_EXPRESSION;
                }

                protected boolean isLeftParen(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/formatter/blocks/JSBlock$1", "isLeftParen"));
                    }
                    return elementType == JSTokenTypes.LPAR;
                }

                protected boolean isRightParen(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/formatter/blocks/JSBlock$1", "isRightParen"));
                    }
                    return elementType == JSTokenTypes.RPAR;
                }

                protected boolean isDot(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/formatter/blocks/JSBlock$1", "isDot"));
                    }
                    return elementType == JSTokenTypes.DOT;
                }

                protected boolean isIdentifier(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/formatter/blocks/JSBlock$1", "isIdentifier"));
                    }
                    return JSKeywordSets.IDENTIFIER_NAMES.contains(elementType);
                }

                protected boolean isEndOfLineComment(@NotNull IElementType elementType) {
                    if (elementType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/formatter/blocks/JSBlock$1", "isEndOfLineComment"));
                    }
                    return elementType == JSTokenTypes.END_OF_LINE_COMMENT;
                }

                protected Block createSubBlock(@NotNull ASTNode node, @NotNull Indent indent) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/blocks/JSBlock$1", "createSubBlock"));
                    }
                    if (indent == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/lang/javascript/formatter/blocks/JSBlock$1", "createSubBlock"));
                    }
                    JSBlock block = this.builder.createSubBlock(node, null, indent, null, JSBlock.this.mySettings, JSBlock.this.myDialect, JSBlock.this.mySharedAlignmentFactory, jsSettings);
                    block.setPolicy(JSBlock.this.myPolicy);
                    return block;
                }
            };
            return builder.buildBlocks();
        }
        return null;
    }

    protected boolean isChainedCallsFormattingSupported() {
        return false;
    }

    protected ASTNodeBasedAlignmentFactory getSharedAlignmentFactory(@Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (jsCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeStyleSettings", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getSharedAlignmentFactory"));
        }
        CommonCodeStyleSettings jsCommonSettings = this.mySettings.getCommonSettings(this.myDialect);
        IElementType nodeType = this.myNode.getElementType();
        if (nodeType == JSElementTypes.OBJECT_LITERAL_EXPRESSION || nodeType == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            JSPropertyAlignmentFactory propertyAlignmentFactory = new JSPropertyAlignmentFactory(jsCodeStyleSettings, this.myAlignment);
            this.myAlignment = null;
            return propertyAlignmentFactory;
        }
        if (JSStubElementTypes.DESTRUCTURING_OBJECT == nodeType) {
            JSPropertyAlignmentFactory propertyAlignmentFactory = new JSPropertyAlignmentFactory(jsCodeStyleSettings, this.myAlignment);
            JSVarStatementAlignmentFactory statementAlignmentFactory = new JSVarStatementAlignmentFactory(jsCodeStyleSettings);
            CompositeAlignmentFactory alignmentFactory = new CompositeAlignmentFactory(propertyAlignmentFactory, statementAlignmentFactory);
            this.myAlignment = null;
            return alignmentFactory;
        }
        if (JSElementTypes.PARAMETER_LISTS.contains(nodeType)) {
            return new JSDefaultParameterValueAlignmentFactory(jsCodeStyleSettings);
        }
        if (nodeType instanceof JSFileElementType || JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeType) || nodeType == JSElementTypes.EMBEDDED_CONTENT) {
            return new JSVarStatementAlignmentFactory(jsCodeStyleSettings);
        }
        if (nodeType == JSElementTypes.BINARY_EXPRESSION) {
            return JSBinaryOperatorAlignmentFactory.getInstance(this.myNode, sharedAlignmentFactory, jsCommonSettings);
        }
        return sharedAlignmentFactory;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getSpacing"));
        }
        return this.mySpacingStrategy.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes attributes;
        int i;
        Block prevBlock;
        Indent indent = null;
        IElementType blockElementType = this.myNode.getElementType();
        CommonCodeStyleSettings jsSettings = this.mySettings.getCommonSettings(this.myDialect);
        JSCodeStyleSettings jsExtraSettings = (JSCodeStyleSettings)this.mySettings.getCustomSettings(JSCodeStyleSettings.class);
        List<Block> subBlocks = this.getSubBlocks();
        JSBlock prevJSBlock = null;
        if (newChildIndex > 0 && newChildIndex <= subBlocks.size() && (prevBlock = subBlocks.get(newChildIndex - 1)) instanceof JSBlock) {
            prevJSBlock = (JSBlock)prevBlock;
        }
        if (blockElementType == JSTokenTypes.DOC_COMMENT) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (blockElementType == JSElementTypes.PACKAGE_STATEMENT) {
            JSCodeStyleSettings customSettings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myNode.getPsi().getProject()).getCustomSettings(JSCodeStyleSettings.class);
            indent = customSettings.INDENT_PACKAGE_CHILDREN == 1 ? Indent.getNormalIndent() : Indent.getNoneIndent();
        } else if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(blockElementType)) {
            ASTNode parent = this.myNode.getTreeParent();
            if (parent != null) {
                indent = parent.getElementType() == JSElementTypes.FUNCTION_DECLARATION ? (jsSettings.METHOD_BRACE_STYLE == 3 ? Indent.getNoneIndent() : Indent.getNormalIndent()) : (jsSettings.BRACE_STYLE == 3 ? Indent.getNoneIndent() : Indent.getNormalIndent());
            }
        } else if (blockElementType instanceof JSClassElementTypeBase || blockElementType == JSElementTypes.OBJECT_LITERAL_EXPRESSION || blockElementType == TypeScriptElementTypes.OBJECT_TYPE || blockElementType == JSElementTypes.TYPESCRIPT_ENUM || blockElementType == JSElementTypes.TYPESCRIPT_MODULE) {
            indent = Indent.getNormalIndent();
        } else if (blockElementType == JSElementTypes.SWITCH_STATEMENT) {
            indent = this.calculateIndentInSwitch(prevJSBlock);
        } else if (blockElementType instanceof JSFileElementType || blockElementType instanceof EmbeddingElementType || this.myNode.getPsi() instanceof JSFile) {
            indent = Indent.getNoneIndent();
        } else if ((JSElementTypes.VAR_STATEMENTS.contains(blockElementType) || blockElementType == JSElementTypes.IF_STATEMENT) && !JSBlock.isStatementDocCommentBlock(prevJSBlock)) {
            indent = Indent.getContinuationIndent();
        } else if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(blockElementType) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(blockElementType) || blockElementType == JSElementTypes.ATTRIBUTE_LIST) {
            indent = Indent.getNoneIndent();
        } else if (blockElementType == JSElementTypes.CALL_EXPRESSION && !jsExtraSettings.INDENT_CHAINED_CALLS) {
            indent = Indent.getNoneIndent();
        }
        Alignment alignment = null;
        for (i = 0; i < newChildIndex && i != subBlocks.size(); ++i) {
            IElementType childType;
            Block subBlock = subBlocks.get(i);
            Alignment childAlignment = subBlock.getAlignment();
            if (childAlignment == null) continue;
            IElementType iElementType = childType = subBlock instanceof JSBlock ? ((JSBlock)subBlock).getNode().getElementType() : null;
            if (blockElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION && childType == JSTokenTypes.LBRACKET || blockElementType == JSElementTypes.OBJECT_LITERAL_EXPRESSION && childType == JSTokenTypes.LBRACE || childType == JSTokenTypes.END_OF_LINE_COMMENT) break;
            alignment = childAlignment;
            break;
        }
        if (blockElementType instanceof JSPropertyElementType) {
            indent = Indent.getNoneIndent();
        }
        if (blockElementType == JSElementTypes.FOR_STATEMENT || blockElementType == JSElementTypes.FOR_IN_STATEMENT) {
            for (i = 0; i < newChildIndex; ++i) {
                if (((JSBlock)subBlocks.get(i)).getNode().getElementType() != JSTokenTypes.RPAR) continue;
                alignment = null;
                break;
            }
        }
        if ((attributes = this.getImportExportDeclarationChildAttributes(newChildIndex, subBlocks, blockElementType, prevJSBlock)) != null) {
            ChildAttributes childAttributes = attributes;
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(indent, alignment);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    protected ChildAttributes getImportExportDeclarationChildAttributes(int newChildIndex, List<Block> subBlocks, @NotNull IElementType blockElementType, @Nullable JSBlock prevJSBlock) {
        if (blockElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockElementType", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getImportExportDeclarationChildAttributes"));
        }
        if ((blockElementType == ES6ElementTypes.IMPORT_DECLARATION || blockElementType == ES6ElementTypes.EXPORT_DECLARATION) && prevJSBlock != null) {
            ASTNode prevNode = prevJSBlock.getNode();
            IElementType prevType = prevNode.getElementType();
            JSBlock siblingBlock = prevJSBlock;
            IElementType siblingElementType = prevType;
            if (prevType == JSTokenTypes.COMMA) {
                Block block;
                int prevPrevIndex = newChildIndex - 2;
                if (prevPrevIndex >= 0 && (block = subBlocks.get(prevPrevIndex)) instanceof JSBlock) {
                    siblingBlock = (JSBlock)block;
                    siblingElementType = siblingBlock.getNode().getElementType();
                }
                if (siblingElementType == ES6ElementTypes.IMPORT_SPECIFIER || siblingElementType == ES6ElementTypes.EXPORT_SPECIFIER) {
                    return new ChildAttributes(siblingBlock.myIndent, siblingBlock.myAlignment);
                }
            }
        }
        return null;
    }

    private static boolean isStatementDocCommentBlock(@Nullable JSBlock block) {
        ASTNode parent;
        ASTNode node;
        return block != null && (node = block.getNode()).getElementType() == JSElementTypes.DOC_COMMENT && (parent = node.getTreeParent()) != null && parent.getFirstChildNode() == node;
    }

    public boolean isIncomplete() {
        return JSBlock.isIncomplete(this.myNode);
    }

    public void setSubBlocks(List<Block> subBlocks) {
        this.mySubBlocks = subBlocks;
    }

    public List<Block> getSubBlocksAsIs() {
        return this.mySubBlocks;
    }

    private static boolean isIncomplete(ASTNode node) {
        ASTNode lastChild;
        node.getPsi().getFirstChild();
        for (lastChild = node.getLastChildNode(); lastChild != null && lastChild.getPsi() instanceof PsiWhiteSpace; lastChild = lastChild.getTreePrev()) {
        }
        if (lastChild == null) {
            return false;
        }
        if (lastChild.getPsi() instanceof PsiErrorElement) {
            return true;
        }
        return JSBlock.isIncomplete(lastChild);
    }

    @NotNull
    public CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = this.mySettings;
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getSettings"));
        }
        return codeStyleSettings;
    }

    public boolean isLeaf() {
        if (this.myNode.getElementType() == JSTokenTypes.DOC_COMMENT) {
            return false;
        }
        return this.myNode.getFirstChildNode() == null;
    }

    private Indent calculateIndentInSwitch(JSBlock prevBlock) {
        ASTNode caseChild;
        CommonCodeStyleSettings jsSettings = this.mySettings.getCommonSettings(this.myDialect);
        boolean indentCase = jsSettings.INDENT_CASE_FROM_SWITCH;
        Indent defaultIndent = indentCase ? Indent.getNormalIndent() : Indent.getNoneIndent();
        Indent indentFromCase = indentCase ? this.getIndentWithNormal(Indent.Type.NORMAL) : Indent.getNormalIndent();
        ASTNode prevNode = prevBlock.getNode();
        if (prevNode.getPsi() instanceof PsiWhiteSpace) {
            prevNode = prevNode.getTreePrev();
        }
        if (prevNode == null) {
            return defaultIndent;
        }
        if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(prevNode.getElementType()) ? (caseChild = prevNode.getLastChildNode()) != null && (caseChild.getElementType() == JSElementTypes.BREAK_STATEMENT || caseChild.getElementType() == JSElementTypes.RETURN_STATEMENT) : prevNode.getElementType() == JSTokenTypes.LBRACE) {
            return defaultIndent;
        }
        return indentFromCase;
    }

    @NotNull
    private Indent getIndentWithNormal(Indent.Type indentType) {
        CommonCodeStyleSettings jsSettings = this.mySettings.getCommonSettings(this.myDialect);
        CommonCodeStyleSettings.IndentOptions indentOptions = jsSettings.getIndentOptions();
        assert (indentOptions != null);
        int extraIndent = indentType == Indent.Type.CONTINUATION ? indentOptions.CONTINUATION_INDENT_SIZE : indentOptions.INDENT_SIZE;
        Indent indent = Indent.getSpaceIndent((int)(indentOptions.INDENT_SIZE + extraIndent));
        if (indent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/blocks/JSBlock", "getIndentWithNormal"));
        }
        return indent;
    }

    public Wrap getChildWrap() {
        return this.myChildWrap;
    }

    public void setChildWrap(Wrap childWrap) {
        this.myChildWrap = childWrap;
    }

    public void setPolicy(XmlFormattingPolicy policy) {
        this.myPolicy = policy;
    }

    public XmlFormattingPolicy getPolicy() {
        return this.myPolicy;
    }
}

