/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.formatter.FormattableInjectedBlockInJS;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.webcore.formatter.chainedMethods.ChainedBlocksSpacingStrategy;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSpacingStrategy
extends ChainedBlocksSpacingStrategy {
    private final JSCodeStyleSettings myJSCodeStyleSettings;
    private final BiFunction<ASTNode, ASTNode, Spacing> myProcessor;

    public JSSpacingStrategy(@NotNull JSCodeStyleSettings dialectSettings, @NotNull CommonCodeStyleSettings commonSettings, @NotNull BiFunction<ASTNode, ASTNode, Spacing> processor) {
        if (dialectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectSettings", "com/intellij/lang/javascript/formatter/blocks/JSSpacingStrategy", "<init>"));
        }
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/javascript/formatter/blocks/JSSpacingStrategy", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/formatter/blocks/JSSpacingStrategy", "<init>"));
        }
        super(commonSettings);
        this.myJSCodeStyleSettings = dialectSettings;
        this.myProcessor = processor;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/lang/javascript/formatter/blocks/JSSpacingStrategy", "getSpacing"));
        }
        Spacing spacing = super.getSpacing(child1, child2);
        if (spacing != null) {
            return spacing;
        }
        if (!JSSpacingStrategy.canComputeSpacing(child1) || !JSSpacingStrategy.canComputeSpacing(child2)) {
            return null;
        }
        return this.myProcessor.apply(((ASTBlock)child1).getNode(), ((ASTBlock)child2).getNode());
    }

    private static boolean canComputeSpacing(Block block) {
        return block instanceof JSBlock || block instanceof XmlTagBlock || block instanceof FormattableInjectedBlockInJS;
    }

    protected boolean isDotOnNewLine() {
        return this.myJSCodeStyleSettings.CHAINED_CALL_DOT_ON_NEW_LINE;
    }
}

