/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.completion.XmlAttributeReferenceCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlAttributeReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ReactXmlAttributeCompletionContributor
extends CompletionContributor {
    public static InsertHandler<LookupElement> HANDLER = (context, item) -> {
        boolean hasAttributeValue;
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = document.getCharsSequence();
        boolean bl = hasAttributeValue = CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=\"") || CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"={") || CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"='");
        if (!hasAttributeValue) {
            String toInsert = "={}";
            if (caretOffset >= document.getTextLength() || "/> \n\t\r".indexOf(document.getCharsSequence().charAt(caretOffset)) < 0) {
                document.insertString(caretOffset, (CharSequence)(toInsert + " "));
            } else {
                document.insertString(caretOffset, (CharSequence)toInsert);
            }
        }
        editor.getCaretModel().moveToOffset(caretOffset + 2);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    };

    public ReactXmlAttributeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)XmlPatterns.xmlAttribute()), new ReactAttributeCompletionProvider());
    }

    @NotNull
    private static Map<String, JSRecordType.PropertySignature> collectAttributeSignatures(@NotNull TypeScriptPropertySignature tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactXmlAttributeCompletionContributor", "collectAttributeSignatures"));
        }
        HashMap resultSignatures = ContainerUtil.newHashMap();
        TypeScriptReactTagUtil.processAttributes(tag, (Processor<JSRecordType.PropertySignature>)((Processor)signature -> {
            String name = signature.getMemberName();
            if (!StringUtil.isEmpty((String)name)) {
                resultSignatures.put(name, signature);
            }
            return true;
        }));
        HashMap hashMap = resultSignatures;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlAttributeCompletionContributor", "collectAttributeSignatures"));
        }
        return hashMap;
    }

    @NotNull
    private static InsertHandler<LookupElement> createInsertHandler(final @NotNull Map<String, JSRecordType.PropertySignature> resultSignatures) {
        if (resultSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSignatures", "com/intellij/lang/javascript/frameworks/react/ReactXmlAttributeCompletionContributor", "createInsertHandler"));
        }
        InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                JSRecordType.PropertySignature signature = (JSRecordType.PropertySignature)resultSignatures.get(item.getLookupString());
                if (signature == null) {
                    XmlAttributeInsertHandler.INSTANCE.handleInsert(context, item);
                    return;
                }
                JSType type = signature.getType();
                if (type == null || type instanceof JSStringType) {
                    XmlAttributeInsertHandler.INSTANCE.handleInsert(context, item);
                    return;
                }
                HANDLER.handleInsert(context, item);
            }
        };
        if (insertHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlAttributeCompletionContributor", "createInsertHandler"));
        }
        return insertHandler;
    }

    private static class ReactAttributeCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private ReactAttributeCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/frameworks/react/ReactXmlAttributeCompletionContributor$ReactAttributeCompletionProvider", "addCompletions"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/react/ReactXmlAttributeCompletionContributor$ReactAttributeCompletionProvider", "addCompletions"));
            }
            PsiFile file = parameters.getOriginalFile();
            if (!(file instanceof JSFile) || !DialectDetector.isJSX((PsiElement)file)) {
                return;
            }
            PsiElement elementOfCompletion = parameters.getPosition();
            PsiReference reference = elementOfCompletion.getContainingFile().findReferenceAt(parameters.getOffset());
            if (reference instanceof XmlAttributeReference) {
                XmlTag declarationTag = ((XmlAttributeReference)reference).getElement().getParent();
                if (ReactXmlExtension.nonJsxTag(declarationTag)) {
                    return;
                }
                if (ReactXmlExtension.isComponentName(declarationTag.getName())) {
                    XmlAttributeReferenceCompletionProvider.addAttributeReferenceCompletionVariants((XmlAttributeReference)((XmlAttributeReference)reference), (CompletionResultSet)result, HANDLER);
                    result.stopHere();
                    return;
                }
                TypeScriptPropertySignature tag = TypeScriptReactTagUtil.resolveTag(declarationTag);
                if (tag == null) {
                    return;
                }
                Map resultSignatures = ReactXmlAttributeCompletionContributor.collectAttributeSignatures(tag);
                InsertHandler handler = ReactXmlAttributeCompletionContributor.createInsertHandler(resultSignatures);
                XmlAttributeReferenceCompletionProvider.addAttributeReferenceCompletionVariants((XmlAttributeReference)((XmlAttributeReference)reference), (CompletionResultSet)result, (InsertHandler)handler);
                result.stopHere();
            }
        }
    }
}

