/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.frameworks.webpack.WebpackInJavaScriptJsonSchemaProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.json.JsonSchemaInJavaScriptAbstractProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonBySchemaObjectAnnotator;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpackConfigHighlightingInspection
extends JSInspection {
    private static final Key<Map<ProblemsHolder, MyAnnotationHolder>> ANNOTATION_HOLDER = Key.create((String)"JavaScript.WebPack.Annotation.Holder");

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = JSBundle.message((String)"js.webpack.config.highlighting.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection", "getGroupDisplayName"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        MyAnnotationHolder annotationHolder;
        LocalInspectionToolSession localInspectionToolSession = session;
        synchronized (localInspectionToolSession) {
            HashMap map = (HashMap)session.getUserData(ANNOTATION_HOLDER);
            if (map == null) {
                map = new HashMap();
                session.putUserDataIfAbsent(ANNOTATION_HOLDER, map);
            }
            annotationHolder = (MyAnnotationHolder)((Object)ContainerUtil.getOrCreate(map, (Object)holder, (Object)((Object)new MyAnnotationHolder(new AnnotationSession(session.getFile()), holder))));
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSElement(JSElement node) {
                this.visitImpl((PsiElement)node);
            }

            private void visitImpl(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection$1", "visitImpl"));
                }
                if (!(element.getContainingFile() != null && WebpackInJavaScriptJsonSchemaProvider.isAvailableForFile(element.getContainingFile().getVirtualFile()) && WebpackInJavaScriptJsonSchemaProvider.isWebpack2(element.getProject()) && WebpackInJavaScriptJsonSchemaProvider.isInPoweredAreaStatic(element) && JsonSchemaInJavaScriptAbstractProvider.isInTopLevelObject(element))) {
                    return;
                }
                annotationHolder.visit(element);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @Nullable
    private static JsonBySchemaObjectAnnotator createAnnotator(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection", "createAnnotator"));
        }
        Ref ref = new Ref();
        VirtualFile schemaFile = WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile();
        JsonSchemaService.Impl.getEx((Project)file.getProject()).visitSchemaObject(schemaFile, object -> {
            ref.set(object);
            return false;
        });
        if (ref.isNull()) {
            return null;
        }
        return new JsonBySchemaObjectAnnotator(schemaFile, (JsonSchemaObject)ref.get());
    }

    private static PsiElement findElementInRange(@NotNull PsiFile file, Annotation next) {
        PsiElement current;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection", "findElementInRange"));
        }
        TextRange range = new TextRange(next.getStartOffset(), next.getEndOffset());
        for (current = file.findElementAt(next.getStartOffset()); current != null && current.getParent() != null; current = current.getParent()) {
            if (range.equals((Object)current.getParent().getTextRange())) {
                return current.getParent();
            }
            if (!current.getParent().getTextRange().contains(range)) continue;
            return current;
        }
        return current;
    }

    private static LocalQuickFix[] convert(@Nullable List<Annotation.QuickFixInfo> info) {
        if (info == null || info.isEmpty()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return info.stream().map(i -> (LocalQuickFix)i.quickFix).collect(Collectors.toList()).toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static class MyAnnotationHolder
    extends AnnotationHolderImpl {
        private final ProblemsHolder myProblemsHolder;
        private final PsiFile myFile;
        private final JsonBySchemaObjectAnnotator myAnnotator;

        public MyAnnotationHolder(@NotNull AnnotationSession session, ProblemsHolder problemsHolder) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection$MyAnnotationHolder", "<init>"));
            }
            super(session);
            this.myFile = session.getFile();
            this.myProblemsHolder = problemsHolder;
            this.myAnnotator = WebpackConfigHighlightingInspection.createAnnotator(this.myFile);
        }

        public void visit(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection$MyAnnotationHolder", "visit"));
            }
            this.myAnnotator.annotate(element, (AnnotationHolder)this);
        }

        public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message, @Nullable String tooltip) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection$MyAnnotationHolder", "createAnnotation"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/frameworks/webpack/WebpackConfigHighlightingInspection$MyAnnotationHolder", "createAnnotation"));
            }
            Annotation annotation = super.createAnnotation(severity, range, message, tooltip);
            PsiElement element = WebpackConfigHighlightingInspection.findElementInRange(this.myFile, annotation);
            this.myProblemsHolder.registerProblem(element, "webpack: " + annotation.getMessage(), WebpackConfigHighlightingInspection.convert(annotation.getQuickFixes()));
            return annotation;
        }
    }
}

