/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileCachedDataEvaluator
extends JSElementVisitor {
    @NotNull
    protected final JSFileCachedData myCachedData;
    private final Stack<Boolean> mySkipChildren;
    private boolean mySkipCurrentElementChildren;

    public JSFileCachedDataEvaluator(@NotNull JSFileCachedData outCachedData) {
        if (outCachedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outCachedData", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "<init>"));
        }
        this.mySkipChildren = ContainerUtil.newStack();
        this.myCachedData = outCachedData;
    }

    public void setSkipChildren() {
        this.mySkipCurrentElementChildren = true;
    }

    public boolean isSkipChildren() {
        return !this.mySkipChildren.isEmpty() && (Boolean)this.mySkipChildren.peek() != false;
    }

    public void startElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "startElement"));
        }
        this.mySkipCurrentElementChildren = this.isSkipChildren();
        if (!this.mySkipCurrentElementChildren) {
            element.accept((PsiElementVisitor)this);
        }
        this.mySkipChildren.push((Object)this.mySkipCurrentElementChildren);
    }

    public void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "finishElement"));
        }
        this.mySkipCurrentElementChildren = (Boolean)this.mySkipChildren.pop();
    }

    public void visitJSCallExpression(JSCallExpression node) {
        JSType type;
        JSExpression moduleInitializer;
        if (node.isRequireCall()) {
            this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker((JSExpression)node));
        } else if (JSAmdPsiUtil.isDefineCall(node) && (moduleInitializer = JSAmdPsiUtil.getModuleInitializer(node)) instanceof JSFunctionExpression && (type = JSSymbolUtil.evaluateModuleInnerAlias((JSFunction)((JSFunctionExpression)moduleInitializer), "exports")) != null) {
            this.myCachedData.setExportsInnerAlias(type);
        }
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME)) {
            handler.processCallExpression(node, this.myCachedData);
        }
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSExpression lOperand = node.getLOperand();
        if (lOperand instanceof JSDefinitionExpression) {
            lOperand = ((JSDefinitionExpression)lOperand).getExpression();
        }
        if (lOperand instanceof JSReferenceExpression) {
            JSExpression qualifier;
            if (JSSymbolUtil.isExportReference((JSReferenceExpression)lOperand)) {
                JSType type;
                this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker((JSExpression)node));
                JSExpression rOperand = node.getROperand();
                if (rOperand != null && (type = this.getExportsInnerAliasType(rOperand)) != null) {
                    this.myCachedData.setExportsInnerAlias(type);
                }
            }
            if ((qualifier = ((JSReferenceExpression)lOperand).getQualifier()) instanceof JSReferenceExpression && JSSymbolUtil.isExportReference((JSReferenceExpression)qualifier)) {
                this.myCachedData.applyModuleStatus(JSFileCachedDataEvaluator.getStatusForCommonJSMarker((JSExpression)node));
            }
        }
    }

    @NotNull
    private static JSFile.ModuleStatus getStatusForCommonJSMarker(JSExpression element) {
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSStatement.class);
        JSFile.ModuleStatus moduleStatus = statement != null && statement.getParent() instanceof PsiFile ? JSFile.ModuleStatus.COMMONJS : JSFile.ModuleStatus.MAYBE_COMMONJS;
        if (moduleStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "getStatusForCommonJSMarker"));
        }
        return moduleStatus;
    }

    @Nullable
    private JSType getExportsInnerAliasType(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "getExportsInnerAliasType"));
        }
        return JSFileCachedDataEvaluator.getTypeForExportedElement(expression, this.myCachedData);
    }

    public static JSType getTypeForExportedElement(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "getTypeForExportedElement"));
        }
        return JSFileCachedDataEvaluator.getTypeForExportedElement(expression, null);
    }

    @Nullable
    private static JSType getTypeForExportedElement(@NotNull JSExpression expression, @Nullable JSFileCachedData fileCachedDataForExportsInnerAlias) {
        JSRequireCallExpressionType reexportType;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "getTypeForExportedElement"));
        }
        if (expression instanceof JSDefinitionExpression) {
            expression = ((JSDefinitionExpression)expression).getExpression();
        }
        if (expression == null) {
            return null;
        }
        JSType nsType = null;
        JSCallExpression requireCall = null;
        if (expression instanceof JSAssignmentExpression) {
            JSType rType;
            JSExpression lOperand = ((JSAssignmentExpression)expression).getLOperand();
            JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
            JSType lType = lOperand != null ? JSFileCachedDataEvaluator.getTypeForExportedElement(lOperand, fileCachedDataForExportsInnerAlias) : null;
            JSType jSType = rType = rOperand != null ? JSFileCachedDataEvaluator.getTypeForExportedElement(rOperand, fileCachedDataForExportsInnerAlias) : null;
            if (lType == null) {
                return rType;
            }
            if (rType == null) {
                return lType;
            }
            return JSCompositeTypeImpl.getCommonType(lType, rType, null, false);
        }
        if (expression instanceof JSReferenceExpression) {
            JSElement refExprValue;
            JSType type;
            JSNamespaceEvaluationResult namespace = JSSymbolUtil.evaluateNamespaceLocallyAsIs(expression);
            JSType jSType = type = namespace != null ? namespace.toType((PsiElement)expression) : null;
            if (type instanceof JSNamedType) {
                nsType = type;
            }
            if ((refExprValue = JSSymbolUtil.calcRefExprValue((JSReferenceExpression)expression)) instanceof JSCallExpression && ((JSCallExpression)refExprValue).isRequireCall()) {
                requireCall = (JSCallExpression)refExprValue;
            }
            if (fileCachedDataForExportsInnerAlias != null && refExprValue instanceof JSExpression && JSFileCachedDataEvaluator.referencesImport((JSExpression)refExprValue, fileCachedDataForExportsInnerAlias)) {
                fileCachedDataForExportsInnerAlias.setReferencesImportInDefaultExport();
            }
        } else if (expression instanceof JSFunctionExpression) {
            JSType type = JSSymbolUtil.evaluateReturnedTypeLocally((JSFunction)((JSFunctionExpression)expression));
            if (type instanceof JSNamedType) {
                return new JSFunctionTypeImpl(JSTypeSource.EMPTY, Collections.emptyList(), type);
            }
        } else if (expression instanceof JSCallExpression && ((JSCallExpression)expression).isRequireCall()) {
            requireCall = (JSCallExpression)expression;
        } else {
            JSNamespaceEvaluationResult result = JSSymbolUtil.evaluateNamespaceLocally(expression);
            if (result != null) {
                nsType = result.toType((PsiElement)expression);
            }
        }
        if (requireCall == null) {
            return nsType;
        }
        String path = CommonJSUtil.getRequireCallModulePath(requireCall);
        JSRequireCallExpressionType jSRequireCallExpressionType = reexportType = path != null ? new JSRequireCallExpressionType(path, JSTypeSource.EMPTY) : null;
        return reexportType == null ? nsType : (nsType == null ? reexportType : JSCompositeTypeImpl.getCommonType(nsType, reexportType, null, false));
    }

    private static boolean referencesImport(@NotNull JSExpression expression, @NotNull JSFileCachedData cachedData) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "referencesImport"));
        }
        if (cachedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedData", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "referencesImport"));
        }
        final Ref referencesImport = Ref.create((Object)Boolean.FALSE);
        expression.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSExpression initializer;
                JSElement localResolve;
                String referenceName = node.getReferenceName();
                if (node.getQualifier() == null && referenceName != null && (localResolve = JSSymbolUtil.resolveLocallyIncludingDefinitions(referenceName, (JSElement)node)) instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)localResolve).getInitializer()) instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                    referencesImport.set((Object)Boolean.TRUE);
                    this.stopWalking();
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSCallExpression(JSCallExpression node) {
                if (node.isRequireCall()) {
                    referencesImport.set((Object)Boolean.TRUE);
                    this.stopWalking();
                }
                super.visitJSCallExpression(node);
            }

            public boolean visitAsFunction(JSFunction function) {
                return true;
            }
        });
        if (((Boolean)referencesImport.get()).booleanValue()) {
            cachedData.setReferencesImportInDefaultExport();
        }
        return (Boolean)referencesImport.get();
    }
}

