/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterInput<T extends JSLinterState> {
    private final Project myProject;
    private final PsiFile myPsiFile;
    private final String myFileContent;
    private final T myState;
    private final EditorColorsScheme myColorsScheme;

    protected JSLinterInput(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull String fileContent, @NotNull T state, @Nullable EditorColorsScheme colorsScheme) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        this.myProject = project;
        this.myPsiFile = psiFile;
        this.myFileContent = JSLinterUtil.convertLineSeparatorsToFileOriginal(fileContent, this.myPsiFile.getViewProvider().getVirtualFile());
        this.myState = state;
        this.myColorsScheme = colorsScheme;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getProject"));
        }
        return project;
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getPsiFile"));
        }
        return psiFile;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myPsiFile.getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getVirtualFile"));
        }
        return virtualFile;
    }

    @NotNull
    public String getFileContent() {
        String string = this.myFileContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getFileContent"));
        }
        return string;
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getState"));
        }
        return t;
    }

    @Nullable
    public EditorColorsScheme getColorsScheme() {
        return this.myColorsScheme;
    }

    @NotNull
    public static <T extends JSLinterState> JSLinterInput<T> create(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull String fileContent, @NotNull T state, @Nullable EditorColorsScheme colorsScheme) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        JSLinterInput<T> jSLinterInput = new JSLinterInput<T>(project, psiFile, fileContent, state, colorsScheme);
        if (jSLinterInput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        return jSLinterInput;
    }
}

