/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.javascript.linter.JSLinterEditConfigFileAction;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterStandardFixes {
    public static final JSLinterStandardFixes DEFAULT = new JSLinterStandardFixes(){

        @Override
        public JSLinterStandardFixes setShowEditSettings(boolean showEditSettings) {
            assert (false);
            return this;
        }

        @Override
        public JSLinterStandardFixes setEditConfig(boolean editConfig) {
            assert (false);
            return this;
        }

        @Override
        public JSLinterStandardFixes setDetailsAction(@Nullable IntentionAction detailsAction) {
            assert (false);
            return this;
        }

        @Override
        public JSLinterStandardFixes setEditSettingsAction(@NotNull IntentionAction intentionAction) {
            if (intentionAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/lang/javascript/linter/JSLinterStandardFixes$1", "setEditSettingsAction"));
            }
            assert (false);
            return this;
        }

        @Override
        public JSLinterStandardFixes setErrorToIntentionConverter(@Nullable Convertor<JSLinterErrorBase, List<IntentionAction>> errorToIntentionConverter) {
            assert (false);
            return this;
        }

        @Override
        public JSLinterStandardFixes setOtherFixes(@Nullable List<IntentionAction> otherFixes) {
            assert (false);
            return this;
        }

        @Override
        @Nullable
        public List<IntentionAction> getOtherFixes() {
            List<IntentionAction> fixes = super.getOtherFixes();
            return fixes == null ? null : Collections.unmodifiableList(fixes);
        }
    };
    private boolean myShowEditSettings = true;
    private boolean myEditConfig = true;
    @Nullable
    private IntentionAction myDetailsAction;
    @Nullable
    private List<IntentionAction> myOtherFixes;
    @Nullable
    private Convertor<JSLinterErrorBase, List<IntentionAction>> myErrorToIntentionConverter;
    @Nullable
    private IntentionAction myEditSettingsAction;

    public boolean isShowEditSettings() {
        return this.myShowEditSettings;
    }

    public JSLinterStandardFixes setShowEditSettings(boolean showEditSettings) {
        this.myShowEditSettings = showEditSettings;
        return this;
    }

    public JSLinterStandardFixes setEditSettingsAction(@NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionAction", "com/intellij/lang/javascript/linter/JSLinterStandardFixes", "setEditSettingsAction"));
        }
        this.myEditSettingsAction = intentionAction;
        this.setShowEditSettings(true);
        return this;
    }

    public boolean isEditConfig() {
        return this.myEditConfig;
    }

    public JSLinterStandardFixes setEditConfig(boolean editConfig) {
        this.myEditConfig = editConfig;
        return this;
    }

    @Nullable
    public IntentionAction getDetailsAction() {
        return this.myDetailsAction;
    }

    public JSLinterStandardFixes setDetailsAction(@Nullable IntentionAction detailsAction) {
        this.myDetailsAction = detailsAction;
        return this;
    }

    @Nullable
    public List<IntentionAction> getOtherFixes() {
        return this.myOtherFixes;
    }

    @Nullable
    public Convertor<JSLinterErrorBase, List<IntentionAction>> getErrorToIntentionConverter() {
        return this.myErrorToIntentionConverter;
    }

    public JSLinterStandardFixes setErrorToIntentionConverter(@Nullable Convertor<JSLinterErrorBase, List<IntentionAction>> errorToIntentionConverter) {
        this.myErrorToIntentionConverter = errorToIntentionConverter;
        return this;
    }

    public JSLinterStandardFixes setOtherFixes(@Nullable List<IntentionAction> otherFixes) {
        this.myOtherFixes = otherFixes;
        return this;
    }

    public List<IntentionAction> createListForError(@Nullable VirtualFile configFile, @NotNull UntypedJSLinterConfigurable configurable, @NotNull JSLinterErrorBase errorBase) {
        List actions;
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/lang/javascript/linter/JSLinterStandardFixes", "createListForError"));
        }
        if (errorBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorBase", "com/intellij/lang/javascript/linter/JSLinterStandardFixes", "createListForError"));
        }
        List<IntentionAction> list = this.createList(configFile, configurable);
        if (this.myErrorToIntentionConverter != null && (actions = (List)this.myErrorToIntentionConverter.convert((Object)errorBase)) != null) {
            list.addAll(actions);
        }
        return list;
    }

    public List<IntentionAction> createList(@Nullable VirtualFile configFile, @NotNull UntypedJSLinterConfigurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/lang/javascript/linter/JSLinterStandardFixes", "createList"));
        }
        ArrayList<IntentionAction> list = new ArrayList<IntentionAction>();
        if (this.myDetailsAction != null) {
            list.add(this.myDetailsAction);
        }
        if (this.myEditConfig && configFile != null) {
            list.add(new JSLinterEditConfigFileAction(configFile));
        }
        if (this.myShowEditSettings) {
            list.add((IntentionAction)(this.myEditSettingsAction != null ? this.myEditSettingsAction : new JSLinterEditSettingsAction(configurable, null)));
        }
        if (this.myOtherFixes != null) {
            list.addAll(this.myOtherFixes);
        }
        return list;
    }

    public JSLinterStandardFixes copy() {
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setEditConfig(this.myEditConfig).setShowEditSettings(this.myShowEditSettings).setDetailsAction(this.myDetailsAction).setErrorToIntentionConverter(this.myErrorToIntentionConverter);
        if (this.myOtherFixes != null) {
            fixes.setOtherFixes(new ArrayList<IntentionAction>(this.myOtherFixes));
        }
        return fixes;
    }
}

