/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditorNotificationPanel;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterWithInspectionExternalAnnotator<T extends JSLinterState, InitialInfoType>
extends ExternalAnnotator<InitialInfoType, JSLinterAnnotationResult<T>> {
    protected final boolean myOnTheFly;

    public JSLinterWithInspectionExternalAnnotator(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    @NotNull
    protected abstract UntypedJSLinterConfigurable createSettingsConfigurable(@NotNull Project var1);

    protected abstract Class<? extends JSLinterConfiguration<T>> getConfigurationClass();

    protected abstract Class<? extends JSLinterInspection> getInspectionClass();

    protected abstract boolean acceptPsiFile(@NotNull PsiFile var1);

    protected boolean acceptState(@NotNull T state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/JSLinterWithInspectionExternalAnnotator", "acceptState"));
        }
        return true;
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @Nullable
    public Icon getFileLevelAnnotationDefaultIcon() {
        return null;
    }

    @Nullable
    protected abstract InitialInfoType createInfo(Project var1, @NotNull PsiFile var2, T var3, Document var4, String var5, EditorColorsScheme var6);

    @Nullable
    public final InitialInfoType collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterWithInspectionExternalAnnotator", "collectInformation"));
        }
        return this.collectInformation(file, null);
    }

    @Nullable
    public final InitialInfoType collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/JSLinterWithInspectionExternalAnnotator", "collectInformation"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/linter/JSLinterWithInspectionExternalAnnotator", "collectInformation"));
        }
        InitialInfoType input = this.collectInformation(file, editor);
        if (input == null) {
            JSLinterEditorNotificationPanel.clearNotification(file.getProject(), this.getInspectionClass(), file.getVirtualFile());
        }
        return input;
    }

    @Nullable
    protected InitialInfoType collectInformation(@NotNull PsiFile psiFile, @Nullable Editor editor) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/JSLinterWithInspectionExternalAnnotator", "collectInformation"));
        }
        Project project = psiFile.getProject();
        if (this.isOnTheFly() && !JSLinterInspection.isToolEnabled(project, this.getInspectionClass(), psiFile)) {
            return null;
        }
        if (psiFile.getContext() != null || !this.acceptPsiFile(psiFile)) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return null;
        }
        if (psiFile.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            return null;
        }
        JSLinterConfiguration<T> configuration = JSLinterConfiguration.getInstance(project, this.getConfigurationClass());
        T state = configuration.getExtendedState().getState();
        if (!this.acceptState(state)) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        String fileContent = document.getText();
        if (StringUtil.isEmptyOrSpaces((String)fileContent)) {
            return null;
        }
        EditorColorsScheme colorsScheme = editor != null ? editor.getColorsScheme() : null;
        return this.createInfo(project, psiFile, state, document, fileContent, colorsScheme);
    }

    public abstract void apply(@NotNull PsiFile var1, @Nullable JSLinterAnnotationResult<T> var2, @NotNull AnnotationHolder var3);

    protected abstract void cleanNotification(@NotNull InitialInfoType var1);

    @Nullable
    public JSLinterAnnotationResult<T> doAnnotate(@Nullable InitialInfoType collectedInfo) {
        if (collectedInfo == null) {
            return null;
        }
        JSLinterAnnotationResult<T> result = this.annotate(collectedInfo);
        if (result == null || !result.hasFileLevelInfo()) {
            this.cleanNotification(collectedInfo);
        }
        return result;
    }

    @Nullable
    public JSLinterAnnotationResult<T> annotate(@NotNull InitialInfoType input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/JSLinterWithInspectionExternalAnnotator", "annotate"));
        }
        return null;
    }

    protected static enum HighlightingGranularity {
        none,
        line,
        element;

    }
}

