/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LinterUnsavedConfigFileManager {
    private static final Logger LOG = Logger.getInstance(LinterUnsavedConfigFileManager.class);
    private static final int SAVE_POSTPONE_TIMEOUT_MILLIS = 3000;
    private final Project myProject;
    private final FileDocumentManager myDocumentManager;
    private final Map<VirtualFile, WatchedDocument> myWatchedDocumentsByFile;
    @Nullable
    private Alarm myAlarm;

    public LinterUnsavedConfigFileManager(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "<init>"));
        }
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "<init>"));
        }
        this.myWatchedDocumentsByFile = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myDocumentManager = documentManager;
    }

    public boolean requestRun(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "requestRun"));
        }
        boolean hasModifiedConfigs = configs.stream().anyMatch(this::isFileModified);
        if (!hasModifiedConfigs) {
            return true;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (configs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "lambda$requestRun$0"));
            }
            this.saveFilesWithDelay(configs);
        });
        return false;
    }

    private void saveFilesWithDelay(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "saveFilesWithDelay"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        this.updateWatchedDocuments(configs);
        this.rescheduleSave();
    }

    private void updateWatchedDocuments(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "updateWatchedDocuments"));
        }
        for (VirtualFile config : configs) {
            Document document;
            if (!this.isFileModified(config) || this.myWatchedDocumentsByFile.containsKey(config) || (document = this.myDocumentManager.getDocument(config)) == null) continue;
            this.myWatchedDocumentsByFile.put(config, new WatchedDocument(config, document));
        }
    }

    private void rescheduleSave() {
        if (this.myAlarm == null) {
            this.myAlarm = new Alarm();
        } else {
            this.myAlarm.cancelAllRequests();
        }
        this.myAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.canSaveNow()) {
                if (this.myAlarm != null) {
                    Disposer.dispose((Disposable)this.myAlarm);
                    this.myAlarm = null;
                }
                this.doSaveFiles();
            } else {
                this.rescheduleSave();
            }
        }, 3100);
    }

    private void doSaveFiles() {
        for (WatchedDocument item : this.myWatchedDocumentsByFile.values()) {
            if (item.myFile.isValid()) {
                LOG.info("Saving " + item.myFile.getPath());
                this.myDocumentManager.saveDocument(item.myDocument);
            }
            item.stop();
        }
        this.myWatchedDocumentsByFile.clear();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private boolean canSaveNow() {
        long currentTimeMillis = System.currentTimeMillis();
        return this.myWatchedDocumentsByFile.values().stream().allMatch(d -> currentTimeMillis - ((WatchedDocument)d).myLastModifiedMillis >= 3000L);
    }

    private boolean isFileModified(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager", "isFileModified"));
        }
        return file.isValid() && !file.isDirectory() && this.myDocumentManager.isFileModified(file);
    }

    private static class WatchedDocument
    extends DocumentAdapter {
        private final VirtualFile myFile;
        private final Document myDocument;
        private long myLastModifiedMillis;

        public WatchedDocument(@NotNull VirtualFile file, @NotNull Document document) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager$WatchedDocument", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager$WatchedDocument", "<init>"));
            }
            this.myFile = file;
            this.myDocument = document;
            this.myDocument.addDocumentListener((DocumentListener)this);
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void documentChanged(DocumentEvent e) {
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void stop() {
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }
}

