/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleConfigurationView {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final NodePackageField myPackageField;

    public NodeModuleConfigurationView(@NotNull Project project, @NotNull String packageName, @NotNull String titlePackageName, @Nullable NodeJsInterpreterRef ref) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "<init>"));
        }
        if (titlePackageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titlePackageName", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "<init>"));
        }
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        if (ref != null) {
            this.myNodeInterpreterField.setInterpreterRef(ref);
        }
        this.myPackageField = new NodePackageField(project, packageName, () -> this.myNodeInterpreterField.getInterpreter());
    }

    public static Pair<TextFieldWithHistoryWithBrowseButton, Getter<Boolean>> createRemotePackageField(final Project project, String name, String titlePackage, final @NotNull Getter<NodeJsInterpreter> nodePathProvider) {
        if (nodePathProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "createRemotePackageField"));
        }
        final TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        final Getter browsingAvailable = () -> {
            if (nodePathProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "lambda$createRemotePackageField$1"));
            }
            String id = ((NodeJsInterpreter)nodePathProvider.get()).getPresentableName();
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt("Choose Remote Package");
            if (manager != null) {
                RemoteSdkAdditionalData data;
                try {
                    data = manager.getRemoteSdkAdditionalData(project, id);
                }
                catch (Exception e) {
                    return false;
                }
                CredentialsType type = data.getRemoteConnectionType();
                if (type instanceof CredentialsTypeEx && !((CredentialsTypeEx)type).isBrowsingAvailable()) {
                    return false;
                }
                return true;
            }
            return false;
        };
        textFieldWithHistoryWithBrowseButton.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String id = ((NodeJsInterpreter)nodePathProvider.get()).getPresentableName();
                NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt("Choose Remote Package");
                if (manager != null) {
                    try {
                        if (!Boolean.TRUE.equals(browsingAvailable.get())) {
                            return;
                        }
                        String path = manager.chooseRemoteFile(project, id, true);
                        if (path != null) {
                            textFieldWithHistoryWithBrowseButton.setText(path);
                        }
                    }
                    catch (Exception e1) {
                        NodeUIUtil.balloonInfo(project, e1.getMessage(), textFieldWithHistoryWithBrowseButton.getLocationOnScreen(), MessageType.ERROR);
                    }
                }
            }
        });
        return Pair.create((Object)textFieldWithHistoryWithBrowseButton, (Object)browsingAvailable);
    }

    public NodeJsInterpreterField getNodeInterpreterField() {
        return this.myNodeInterpreterField;
    }

    public NodePackageField getPackageField() {
        return this.myPackageField;
    }

    @NotNull
    public static List<String> detectPackageDirs(Project project, String name, @NotNull Getter<String> nodePathProvider) {
        if (nodePathProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathProvider", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "detectPackageDirs"));
        }
        ArrayList modules = ContainerUtil.newArrayList();
        String nodePathStr = (String)nodePathProvider.get();
        NodeSettings nodeSettings = nodePathStr == null ? null : NodeModuleConfigurationView.createNodeSettings(new File(nodePathStr));
        NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)modules, name, project.getBaseDir(), nodeSettings, true);
        if (modules.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "detectPackageDirs"));
            }
            return list;
        }
        ArrayList dirs = ContainerUtil.newArrayList();
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            dirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/NodeModuleConfigurationView", "detectPackageDirs"));
        }
        return arrayList;
    }

    private static NodeSettings createNodeSettings(File typedPath) {
        if (typedPath.exists() && typedPath.isFile() && typedPath.canExecute()) {
            return new NodeSettings(typedPath.getAbsolutePath());
        }
        File path = NodeDetectionUtil.findInterpreterInPath();
        if (path != null && path.exists() && path.isFile() && path.canExecute()) {
            return new NodeSettings(path.getAbsolutePath());
        }
        return null;
    }

    public void setPreferredWidthToComponents() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
    }
}

