/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterNpmPackageDoesNotExistsException;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintPackage;
import com.intellij.lang.javascript.linter.eslint.EslintSessionData;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUnsavedConfigManager;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.config.EslintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EsLintExternalRunner {
    private static final Logger LOG = Logger.getInstance(EsLintExternalRunner.class);
    private final boolean myIsOnTheFly;
    private boolean myIsFix;
    private final EslintLanguageServiceClient myLanguageService;

    public EsLintExternalRunner(boolean isOnTheFly, boolean isFix, EslintLanguageServiceClient service) {
        this.myIsOnTheFly = isOnTheFly;
        this.myIsFix = isFix;
        this.myLanguageService = service;
    }

    @Nullable
    private static EslintSessionData createSessionData(@NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter, @NotNull EslintPackage eslintPackage, @NotNull VirtualFile fileToLint, @NotNull String fileContentToLint, @Nullable VirtualFile specifiedConfigurationFile, @Nullable File additionalRulesDir, @NotNull String extraOptions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (eslintPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintPackage", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (fileContentToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContentToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        if (extraOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraOptions", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "createSessionData"));
        }
        VirtualFile workingDir = EsLintExternalRunner.guessWorkingDirectory(project, fileToLint);
        if (workingDir == null) {
            LOG.debug("No working directory detected, setting to file's parent directory");
            VirtualFile fileDir = fileToLint.getParent();
            if (fileDir == null) {
                LOG.debug(String.format("No parent directory for file %s", fileToLint.getPath()));
                return null;
            }
            workingDir = fileDir;
        }
        return new EslintSessionData(interpreter, eslintPackage, workingDir, fileToLint, fileContentToLint, specifiedConfigurationFile, additionalRulesDir, extraOptions);
    }

    @Nullable
    private static VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull VirtualFile fileToLint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "guessWorkingDirectory"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "guessWorkingDirectory"));
        }
        VirtualFile eslintIgnoreFile = JSLinterConfigFileUtil.findFileUpFileSystemRoot(fileToLint, ".eslintignore");
        VirtualFile eslintIgnoreFileDir = eslintIgnoreFile != null ? eslintIgnoreFile.getParent() : null;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(fileToLint, false);
        if (eslintIgnoreFileDir == null) {
            return contentRoot;
        }
        if (contentRoot == null) {
            return eslintIgnoreFileDir;
        }
        return VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)eslintIgnoreFileDir, (boolean)true) ? eslintIgnoreFileDir : contentRoot;
    }

    @Nullable
    private JSLinterAnnotationResult<EslintState> eslint(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "eslint"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "eslint"));
        }
        long startNanoTime = System.nanoTime();
        if (!EslintUtil.configAllowsFileType(input.getPsiFile(), input.getProject(), sessionData.findConfigs())) {
            return null;
        }
        JSLinterAnnotationResult<EslintState> result = this.runProcess(input, sessionData);
        long durationMillis = TimeoutUtil.getDurationMillis((long)startNanoTime);
        String report = "found " + result.getErrors().size() + " problems";
        LOG.debug(String.format("Done in %d ms, %s", durationMillis, report));
        return result;
    }

    @NotNull
    private JSLinterAnnotationResult<EslintState> runProcess(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData) {
        List<VirtualFile> configs;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
        }
        VirtualFile config = sessionData.getSpecifiedConfigFile();
        if (config == null && (config = (VirtualFile)ContainerUtil.getFirstItem(configs = EslintUtil.findAllConfigsUpFileSystem(sessionData.getFileToLint()))) == null) {
            config = JSLinterConfigFileUtil.findFileUpFileSystemRoot(sessionData.getFileToLint(), "package.json");
        }
        String error = null;
        Future<Pair<String, List<JSLinterError>>> future = this.myIsFix ? this.myLanguageService.highlightAndFix(sessionData.getFileToLint(), config, input.getState().getExtraOptions()) : this.myLanguageService.highlight(sessionData.getFileToLint(), config, sessionData.getFileToLintContent(), input.getState().getExtraOptions());
        Pair<String, List<JSLinterError>> pair = JSLanguageServiceUtil.awaitFuture(future);
        if (pair == null) {
            error = !this.myLanguageService.isServiceCreated() || this.myLanguageService.getServiceCreationError() != null ? ((error = this.myLanguageService.getServiceCreationError()) == null ? "Cannot start language service process" : error) : "Can not get result of ESLint annotation";
        } else if (pair.getFirst() != null) {
            error = (String)pair.getFirst();
        }
        if (error != null) {
            ProcessOutput output = new ProcessOutput();
            output.appendStderr(error);
            IntentionAction detailsAction = pair == null ? null : JSLinterUtil.createDetailsAction(input.getProject(), sessionData.getFileToLint(), null, output, JavaScriptLanguageIcons.FileTypes.Eslint);
            JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult = JSLinterAnnotationResult.create(input, EsLintExternalRunner.createFileLevelAnnotation(error, detailsAction), config);
            if (jSLinterAnnotationResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
            }
            return jSLinterAnnotationResult;
        }
        JSLinterAnnotationResult<EslintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterResult(input, (List)pair.getSecond(), config);
        if (jSLinterAnnotationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "runProcess"));
        }
        return jSLinterAnnotationResult;
    }

    public static JSLinterFileLevelAnnotation createFileLevelAnnotation(String error, @Nullable IntentionAction detailsAction) {
        String[] strings;
        JSLinterFileLevelAnnotation annotation = detailsAction == null ? new JSLinterFileLevelAnnotation(error) : new JSLinterFileLevelAnnotation(error, detailsAction);
        for (String string : strings = StringUtil.filterEmptyStrings((String[])StringUtil.splitByLines((String)error))) {
            if (FileUtil.isAbsolute((String)(string = string.trim())) || string.endsWith(":") && FileUtil.isAbsolute((String)string.substring(0, string.length() - 1)) || string.startsWith("Oops! Something went wrong! :(")) continue;
            annotation.setShortMessage(string);
            break;
        }
        return annotation.withIcon(JavaScriptLanguageIcons.FileTypes.Eslint);
    }

    @Nullable
    static File getAdditionalRulesDir(@NotNull String additionalRulesDirPath) throws IOException {
        if (additionalRulesDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalRulesDirPath", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "getAdditionalRulesDir"));
        }
        if (additionalRulesDirPath.isEmpty()) {
            return null;
        }
        File dir = new File(additionalRulesDirPath);
        if (!dir.isDirectory() || !dir.isAbsolute()) {
            throw new IOException("Please correct path to additional rules directory");
        }
        return dir;
    }

    public JSLinterAnnotationResult<EslintState> execute(@NotNull JSLinterInput<EslintState> input) {
        Project project;
        EslintSessionData sessionData;
        VirtualFile specifiedConfigFile;
        File additionalRulesDir;
        EslintPackage eslintPackage;
        NodeJsLocalInterpreter localInterpreter;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "execute"));
        }
        VirtualFile fileToLint = input.getVirtualFile();
        if (!fileToLint.isValid()) {
            return null;
        }
        VirtualFile fileDir = fileToLint.getParent();
        if (fileDir == null) {
            return null;
        }
        EslintState state = input.getState();
        try {
            NodeJsInterpreter interpreter = state.getInterpreterRef().resolve(input.getProject());
            localInterpreter = NodeJsLocalInterpreter.castAndValidate(interpreter);
        }
        catch (ExecutionException e) {
            return JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(StringUtil.decapitalize((String)e.getMessage())), null);
        }
        try {
            eslintPackage = new EslintPackage(input.getProject(), state.getEslintPackagePath());
            additionalRulesDir = EsLintExternalRunner.getAdditionalRulesDir(state.getAdditionalRulesDirPath());
        }
        catch (JSLinterNpmPackageDoesNotExistsException e) {
            return JSLinterAnnotationResult.create(input, e.getAnnotation(), null);
        }
        catch (IOException e) {
            return JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation(e.getMessage()), null);
        }
        if (state.isCustomConfigFileUsed()) {
            specifiedConfigFile = JSLinterConfigFileUtil.findLocalFileByPath(state.getCustomConfigFilePath());
            if (specifiedConfigFile == null || !specifiedConfigFile.isValid()) {
                return JSLinterAnnotationResult.create(input, new JSLinterFileLevelAnnotation("Please correct path to ESLint configuration file"), null);
            }
        } else {
            specifiedConfigFile = null;
        }
        if ((sessionData = (EslintSessionData)ReadAction.compute(() -> this.lambda$execute$0(project = input.getProject(), localInterpreter, eslintPackage, fileToLint, input, specifiedConfigFile, additionalRulesDir, state))) == null) {
            return null;
        }
        boolean runGranted = true;
        List<VirtualFile> packageJsonFiles = PackageJsonUtil.collectPackageJsonFiles(project, sessionData.getFileToLint());
        List requiredFilesToRun = ContainerUtil.concat(sessionData.findConfigs(), packageJsonFiles);
        if (this.myIsOnTheFly) {
            runGranted = (Boolean)ReadAction.compute(() -> {
                if (project.isDisposed()) {
                    return false;
                }
                EslintUnsavedConfigManager unsavedConfigsManager = EslintUnsavedConfigManager.getInstance(project);
                if (unsavedConfigsManager.requestRun(requiredFilesToRun)) {
                    return true;
                }
                LOG.info("ESLint postponed because of unsaved configs");
                return false;
            });
        }
        if (runGranted) {
            return this.eslint(input, sessionData);
        }
        return null;
    }

    private /* synthetic */ EslintSessionData lambda$execute$0(Project project, NodeJsLocalInterpreter localInterpreter, EslintPackage eslintPackage, VirtualFile fileToLint, @NotNull JSLinterInput input, VirtualFile specifiedConfigFile, File additionalRulesDir, EslintState state) throws RuntimeException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner", "lambda$execute$0"));
        }
        if (project.isDisposed()) {
            return null;
        }
        if (this.myIsOnTheFly) {
            EslintConfigFileChangeTracker.getInstance(project).startIfNeeded();
        }
        return EsLintExternalRunner.createSessionData(project, localInterpreter, eslintPackage, fileToLint, input.getFileContent(), specifiedConfigFile, additionalRulesDir, state.getExtraOptions());
    }
}

