/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.ActionScriptCodeContextType;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JSComponentTypeOfMacro
extends Macro {
    public String getName() {
        return "jsComponentTypeOf";
    }

    public String getPresentableName() {
        return JSBundle.message((String)"macro.js.component.type.of", (Object[])new Object[0]);
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        PsiFile contextPsiFile;
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/lang/javascript/macro/JSComponentTypeOfMacro", "calculateResult"));
        }
        if (params.length != 1) {
            return null;
        }
        Result result = params[0].calculateResult(context);
        if (result == null) {
            return null;
        }
        PsiElement elementFromContext = JSMacroUtil.getElementFromContext(context);
        if (elementFromContext != null && (contextPsiFile = elementFromContext.getContainingFile()) != null) {
            PsiFile psiFile;
            PsiElement collectionExpression;
            ASTNode astNode = JSChangeUtil.createExpressionFromText(context.getProject(), result.toString(), JavaScriptSupportLoader.ECMA_SCRIPT_L4);
            PsiElement psiElement = collectionExpression = astNode == null ? null : astNode.getPsi();
            if (collectionExpression instanceof JSExpression && (psiFile = collectionExpression.getContainingFile()) != null) {
                psiFile.putUserData(JSResolveUtil.contextKey, (Object)elementFromContext);
                String expressionType = JSResolveUtil.getQualifiedExpressionType((JSExpression)collectionExpression, psiFile);
                if (JSTypeEvaluateManager.isArrayType(expressionType)) {
                    String type = JSTypeEvaluateManager.getComponentType(expressionType);
                    return new TextResult(type);
                }
            }
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaScriptCodeContextType || context instanceof ActionScriptCodeContextType;
    }
}

