/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JsDefinedInObject;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleReferenceExpressionInfo
implements ModuleReferenceInfo {
    @Nullable
    private final String myModuleName;
    private String myTopLevelMember;
    private JSReferenceExpression myTopLevelInModuleRef;
    private String[] myChain;
    private boolean myUsesPredefined;
    @Nullable
    private List<JSReferenceExpression> myTailRef;

    public JSModuleReferenceExpressionInfo(@NotNull JSReferenceExpression node) {
        PsiElement current;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo", "<init>"));
        }
        this.myModuleName = node.getReferenceName();
        if (node.getParent() instanceof JSNewExpression) {
            if (!(node.getParent().getParent() instanceof JSReferenceExpression)) {
                return;
            }
            current = node.getParent().getParent();
        } else if (node.getParent() instanceof JSReferenceExpression) {
            current = node.getParent();
        } else {
            return;
        }
        this.myTailRef = new ArrayList<JSReferenceExpression>();
        ArrayList<String> parts = new ArrayList<String>();
        while (current instanceof JSReferenceExpression) {
            String referenceName;
            this.myTailRef.add((JSReferenceExpression)current);
            if (parts.isEmpty()) {
                this.myTopLevelInModuleRef = (JSReferenceExpression)current;
            }
            if ((referenceName = ((JSReferenceExpression)current).getReferenceName()) != null) {
                parts.add(referenceName);
            }
            current = current.getParent();
        }
        if (parts.isEmpty()) {
            return;
        }
        if (!parts.isEmpty()) {
            this.myTopLevelMember = (String)parts.get(0);
            this.myUsesPredefined = JsDefinedInObject.isPredefined(this.myTopLevelMember, DialectDetector.dialectOfFile(node.getContainingFile()));
            this.myChain = ArrayUtil.toStringArray(parts);
        } else {
            this.resetTail();
        }
        if (this.myUsesPredefined) {
            this.resetTail();
        }
    }

    private void resetTail() {
        this.myTopLevelMember = null;
        this.myTopLevelInModuleRef = null;
        this.myChain = new String[0];
    }

    @Override
    @Nullable
    public List<JSReferenceExpression> getTailRef() {
        return this.myTailRef;
    }

    @Nullable
    public JSReferenceExpression getTopLevelInModuleRef() {
        return this.myTopLevelInModuleRef;
    }

    @Override
    public boolean processFromIndeces() {
        return false;
    }

    @Override
    @NotNull
    public ResolveResult[] resolveTopLevelInModuleRef() {
        JSReferenceExpression ref = this.getTopLevelInModuleRef();
        ResolveResult[] resolveResultArray = ref == null ? ResolveResult.EMPTY_ARRAY : ref.multiResolve(false);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo", "resolveTopLevelInModuleRef"));
        }
        return resolveResultArray;
    }

    @Override
    public boolean isAcceptable(@NotNull PsiElement elementToImport) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/javascript/modules/JSModuleReferenceExpressionInfo", "isAcceptable"));
        }
        return true;
    }

    @Override
    @Nullable
    public String getModuleName() {
        return this.myModuleName;
    }

    @Override
    public boolean needHint() {
        return false;
    }

    @Override
    @Nullable
    public String getReferenceName() {
        return this.myModuleName;
    }

    @Override
    public String getTopLevelMember() {
        return this.myTopLevelMember;
    }

    @Override
    public String[] getChain() {
        return this.myChain;
    }

    @Override
    public boolean haveTail() {
        return this.myChain != null && this.myChain.length > 0;
    }

    public boolean isUsesPredefined() {
        return this.myUsesPredefined;
    }
}

