/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSMethodNavigationOffsetProvider
implements MethodNavigationOffsetProvider {
    public int[] getMethodNavigationOffsets(PsiFile file, int caretOffset) {
        PsiElement elementAtCaret;
        JSEmbeddedContent embeddedContent;
        PsiFile rootElement = null;
        if (file instanceof JSFile) {
            rootElement = file;
        } else if (file instanceof XmlFile && (embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)(elementAtCaret = file.findElementAt(caretOffset)), JSEmbeddedContent.class)) != null) {
            rootElement = embeddedContent;
        }
        if (rootElement == null) {
            return null;
        }
        final ArrayList array = new ArrayList();
        rootElement.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSClass(JSClass aClass) {
                array.add(aClass);
                ASTNode rBrace = aClass.getNode().findChildByType(JSTokenTypes.RBRACE);
                if (rBrace != null) {
                    array.add(rBrace.getPsi());
                }
                super.visitJSClass(aClass);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/navigation/JSMethodNavigationOffsetProvider$1", "visitJSFunctionDeclaration"));
                }
                array.add(node);
            }

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/navigation/JSMethodNavigationOffsetProvider$1", "visitJSFunctionExpression"));
                }
                PsiElement parent = node.getParent();
                if (parent instanceof JSArgumentList || parent instanceof JSExpression && !(parent instanceof JSAssignmentExpression)) {
                    return;
                }
                array.add(node);
            }
        });
        return MethodUpDownUtil.offsetsFromElements(array);
    }
}

