/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeNameValuePairImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSAttributeStub;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.dtd.XmlNSDescriptorImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAttributeImpl
extends JSStubElementImpl<JSAttributeStub>
implements JSAttribute {
    public static final String URN_FLEX_META = "urn:Flex:Meta";
    private PsiReference[] myReferences;
    private static final String[] IGNORED_ATTRS = new String[]{"theme"};

    public JSAttributeImpl(ASTNode node) {
        super(node);
    }

    public JSAttributeImpl(JSAttributeStub node) {
        super(node, (IStubElementType)JSStubElementTypes.ATTRIBUTE);
    }

    public JSAttributeImpl(JSAttributeStub node, JSStubElementType<JSAttributeStub, JSAttribute> elementType) {
        super(node, (IStubElementType)elementType);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSTokenTypes.IDENTIFIER_TOKENS_SET);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement parentNavElement;
        PsiElement parent = this.getParent();
        PsiElement psiElement = parent = parent != null ? parent.getParent() : null;
        if (parent instanceof JSClass && (parentNavElement = parent.getNavigationElement()) != parent) {
            MyProcessor processor = new MyProcessor();
            ActionScriptResolveUtil.processMetaAttributesForClass(parentNavElement, processor);
            if (processor.myAttribute != null) {
                JSAttribute jSAttribute = processor.myAttribute;
                if (jSAttribute == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl", "getNavigationElement"));
                }
                return jSAttribute;
            }
        }
        PsiElement psiElement2 = super.getNavigationElement();
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl", "getNavigationElement"));
        }
        return psiElement2;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSAttribute((JSAttribute)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getName() {
        JSAttributeStub attributeStub = (JSAttributeStub)this.getGreenStub();
        if (attributeStub != null) {
            return attributeStub.getName();
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier != null ? nameIdentifier.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl", "setName"));
        }
        throw new IncorrectOperationException();
    }

    public JSAttributeNameValuePair[] getValues() {
        return (JSAttributeNameValuePair[])this.getStubOrPsiChildren((IStubElementType)JSStubElementTypes.ATTRIBUTE_NAME_VALUE_PAIR, (PsiElement[])JSAttributeNameValuePair.EMPTY_ARRAY);
    }

    public JSAttributeNameValuePair getValueByName(String name) {
        for (JSAttributeNameValuePair p : this.getValues()) {
            String pName = p.getName();
            if ((name == null || !name.equals(pName)) && (name != null || pName != null)) continue;
            return p;
        }
        return null;
    }

    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length > 0 ? references[0] : null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (this.myReferences == null) {
            ASTNode node = this.getNode().findChildByType(JSTokenTypes.IDENTIFIER_TOKENS_SET);
            if (node == null) {
                this.myReferences = PsiReference.EMPTY_ARRAY;
            } else {
                int startOffsetInParent = node.getPsi().getStartOffsetInParent();
                TextRange range = new TextRange(startOffsetInParent, startOffsetInParent + node.getTextLength());
                this.myReferences = this.createReferences(range);
            }
        }
        if (this.myReferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl", "getReferences"));
        }
        return this.myReferences;
    }

    @NotNull
    protected PsiReference[] createReferences(TextRange range) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new AttrNameReference(this, range)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myReferences = null;
    }

    public XmlElementDescriptor getBackedDescriptor() {
        PsiReference parentNameRef = this.getReference();
        if (parentNameRef instanceof AttrNameReference) {
            return ((AttrNameReference)parentNameRef).getElementDescriptor();
        }
        return null;
    }

    private static class AttrNameReference
    implements PsiReference,
    EmptyResolveMessageProvider {
        private final TextRange myRange;
        private final JSAttribute myElement;

        public AttrNameReference(JSAttribute elt, TextRange range) {
            this.myElement = elt;
            this.myRange = range;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public TextRange getRangeInElement() {
            return this.myRange;
        }

        public PsiElement resolve() {
            XmlElementDescriptor descriptor = this.getElementDescriptor();
            if (descriptor != null) {
                return descriptor.getDeclaration();
            }
            String s = this.getCanonicalText();
            return ArrayUtil.indexOf((Object[])this.getVariants(), (Object)s) >= 0 ? this.myElement : null;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myElement.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl$AttrNameReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl$AttrNameReference", "bindToElement"));
            }
            return null;
        }

        public boolean isReferenceTo(PsiElement element) {
            if (element instanceof JSAttribute) {
                String name = this.getCanonicalText();
                return name.equals(((JSAttribute)element).getName());
            }
            return false;
        }

        @NotNull
        public Object[] getVariants() {
            XmlNSDescriptorImpl descriptor = this.getNsDescriptor();
            if (descriptor != null) {
                Object[] objectArray = descriptor.getRootElementsDescriptors(null);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl$AttrNameReference", "getVariants"));
                }
                return objectArray;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl$AttrNameReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        XmlElementDescriptor getElementDescriptor() {
            XmlNSDescriptorImpl nsDescriptor = this.getNsDescriptor();
            if (nsDescriptor != null) {
                return nsDescriptor.getElementDescriptor(this.getCanonicalText());
            }
            return null;
        }

        private XmlNSDescriptorImpl getNsDescriptor() {
            PsiFile containingFile = this.myElement.getContainingFile();
            String s = ExternalResourceManager.getInstance().getResourceLocation(JSAttributeImpl.URN_FLEX_META, containingFile.getProject());
            VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)s, (VirtualFile)containingFile.getOriginalFile().getVirtualFile());
            if (relativeFile == null) {
                return null;
            }
            PsiFile file = containingFile.getManager().findFile(relativeFile);
            if (!(file instanceof XmlFile)) {
                return null;
            }
            XmlDocument document = ((XmlFile)file).getDocument();
            if (document == null) {
                return null;
            }
            PsiMetaData metaData = document.getMetaData();
            if (metaData instanceof XmlNSDescriptorImpl) {
                return (XmlNSDescriptorImpl)metaData;
            }
            return null;
        }

        public boolean isSoft() {
            return true;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if ("Unknown metadata tag" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl$AttrNameReference", "getUnresolvedMessagePattern"));
            }
            return "Unknown metadata tag";
        }
    }

    private class MyProcessor
    implements ActionScriptResolveUtil.MetaDataProcessor {
        JSAttribute myAttribute;

        private MyProcessor() {
        }

        @Override
        public boolean process(@NotNull JSAttribute jsAttribute) {
            JSAttributeNameValuePair[] pairs2;
            if (jsAttribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsAttribute", "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeImpl$MyProcessor", "process"));
            }
            if (this == jsAttribute) {
                this.myAttribute = jsAttribute;
                return true;
            }
            if (!Comparing.equal((String)jsAttribute.getName(), (String)JSAttributeImpl.this.getName())) {
                return true;
            }
            JSAttributeNameValuePair[] pairs1 = JSAttributeImpl.this.getValues();
            if (pairs1.length != (pairs2 = jsAttribute.getValues()).length) {
                return true;
            }
            for (JSAttributeNameValuePair pair1 : pairs1) {
                if (ArrayUtil.contains((String)pair1.getName(), (String[])IGNORED_ATTRS)) continue;
                boolean found = false;
                for (JSAttributeNameValuePair pair2 : pairs2) {
                    if (!JSAttributeNameValuePairImpl.areEquivalent(pair1, pair2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return true;
            }
            this.myAttribute = jsAttribute;
            return false;
        }

        @Override
        public boolean handleOtherElement(PsiElement el, PsiElement context, @Nullable Ref<PsiElement> continuePassElement) {
            return true;
        }
    }
}

