/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSEmbeddedContentStub;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.types.JSEmbeddedContentElementType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSEmbeddedContentImpl
extends JSStubElementImpl<JSEmbeddedContentStub>
implements JSEmbeddedContent,
XmlTagChild {
    public JSEmbeddedContentImpl(ASTNode node) {
        super(node);
    }

    protected JSEmbeddedContentImpl(JSEmbeddedContentStub stub, IStubElementType type) {
        super(stub, type);
    }

    public XmlTag getParentTag() {
        PsiElement parent = this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    public boolean processElements(PsiElementProcessor processor, PsiElement place) {
        return true;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSEmbeddedContentImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSEmbeddedContentImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSEmbeddedContentImpl", "processDeclarations"));
        }
        return JSResolveUtil.processDeclarationsInScope(this, processor, state, lastParent, place) && (this.getParent().getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) || JSFileImpl.processGlobalThings(processor, state, place, (PsiElement)this));
    }

    @Override
    public String toString() {
        String s = super.toString();
        IElementType type = this.getNode().getElementType();
        if (type != JSElementTypes.EMBEDDED_CONTENT) {
            s = s + ":" + type;
        }
        return s;
    }

    public void delete() throws IncorrectOperationException {
        ASTNode astNode = this.getNode();
        astNode.getTreeParent().removeChild(astNode);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSEmbeddedContentImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSEmbeddedContent((JSEmbeddedContent)this);
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public Map<String, JSReferenceExpression> getExtensionSymbols() {
        Map<String, JSReferenceExpression> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSEmbeddedContentImpl", "getExtensionSymbols"));
        }
        return map;
    }

    public static Language getLanguageForParser(@NotNull IElementType elementType, @NotNull Project project) {
        Language forcedLanguage;
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/impl/JSEmbeddedContentImpl", "getLanguageForParser"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/impl/JSEmbeddedContentImpl", "getLanguageForParser"));
        }
        Language language = forcedLanguage = elementType instanceof JSEmbeddedContentElementType ? ((JSEmbeddedContentElementType)elementType).getForcedLanguage() : null;
        if (forcedLanguage != null) {
            return forcedLanguage;
        }
        JSRootConfiguration configuration = JSRootConfiguration.getInstance(project);
        return configuration != null ? configuration.getLanguageLevel().getDialect() : JSLanguageLevel.DEFAULT.getDialect();
    }
}

