/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveHelper;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileImpl
extends JSFileBaseImpl
implements JSFile {
    public JSFileImpl(@NotNull FileViewProvider fileViewProvider, @NotNull Language language) {
        if (fileViewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileViewProvider", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "<init>"));
        }
        super(fileViewProvider, language);
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getViewProvider().getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "getFileType"));
        }
        return fileType;
    }

    public String toString() {
        return "JSFile:" + this.getName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        boolean areNotRequestedForMembersProcessing;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processDeclarations"));
        }
        boolean bl = areNotRequestedForMembersProcessing = !Boolean.TRUE.equals(state.get(XmlBackedJSClass.PROCESS_XML_BACKED_CLASS_MEMBERS_HINT));
        if (areNotRequestedForMembersProcessing && ActionScriptResolveUtil.weShouldSkipResolveBecauseOfImplicitClass((PsiElement)this)) {
            return true;
        }
        if (areNotRequestedForMembersProcessing) {
            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        }
        if (!JSResolveUtil.processDeclarationsInScope((JSElement)this, processor, state, lastParent, place)) {
            return false;
        }
        if (lastParent == null) {
            return true;
        }
        if (!(lastParent instanceof JSPackageStatement) && !JSImportHandlingUtil.tryResolveImports(processor, (PsiNamedElement)this, place)) {
            return false;
        }
        return JSFileImpl.processGlobalThings(processor, state, place, (PsiElement)this);
    }

    public static boolean processGlobalThings(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiElement scope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processGlobalThings"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processGlobalThings"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processGlobalThings"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processGlobalThings"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(scope);
        if (holder == null || !(processor instanceof ResolveProcessor)) {
            return true;
        }
        if (holder.isECMA4 && (JSResolveUtil.shouldProcessImports(place, processor) || place.getParent() instanceof JSImportStatement && ((ResolveProcessor)processor).getName() == null)) {
            return JSResolveUtil.processGlobalThings((ResolveProcessor)processor, state, place, scope);
        }
        if (holder.isTypeScript && !((ResolveProcessor)processor).isLocalResolve()) {
            if (processor instanceof SinkResolveProcessor) {
                Object sink = ((SinkResolveProcessor)processor).getResultSink();
                ((ResultSink)sink).startGlobalDeclarations();
            }
            return TypeScriptResolveHelper.processGlobalThings((ResolveProcessor)processor, state, place);
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSFile((JSFile)this);
        } else {
            super.accept(visitor);
        }
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "addRangeBefore"));
        }
        if (JSChangeUtil.isStatementOrComment(first)) {
            return JSChangeUtil.doAddRangeBefore((PsiElement)this, first, last, anchor);
        }
        return super.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.addRangeAfter(first, last, null);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "addAfter"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "addBefore"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
        }
        return super.addBefore(element, anchor);
    }

    public boolean isWritable() {
        return super.isWritable() && !this.isPredefined();
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (JSChangeUtil.isStatementOrComment(first)) {
            return JSChangeUtil.doAddRangeAfter((PsiElement)this, first, last, anchor);
        }
        return super.addRangeAfter(first, last, anchor);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "add"));
        }
        return this.addAfter(element, null);
    }

    public JSSourceElement[] getStatements() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (JSSourceElement[])stub.getChildrenByType(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, (PsiElement[])JSSourceElement.EMPTY_ARRAY);
        }
        return (JSSourceElement[])this.findChildrenByClass(JSSourceElement.class);
    }

    public boolean isPredefined() {
        return JSResolveUtil.isFromPredefinedFile((PsiFile)this);
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }
}

