/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.psi.stubs.JSDocCommentStub;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSPossiblyStoredStubImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocCommentStubImpl
extends JSPossiblyStoredStubImpl<JSDocComment>
implements JSDocCommentStub {
    private static final BooleanStructureElement HAS_GENERIC_PARAMETERS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_INTERFACE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_CONSTRUCTS_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_NAMESPACE_TAG_FLAG = new BooleanStructureElement();
    private static final EnumStructureElement<JSContext> JS_CONTEXT_FLAG = new EnumStructureElement<JSContext>(JSContext.class);
    private static final EnumStructureElement<JSDocComment.BrowserFamily> BROWSER_FAMILY_FLAG = new EnumStructureElement<JSDocComment.BrowserFamily>(JSDocComment.BrowserFamily.class);
    private static final BooleanStructureElement IS_CLASS_EXPLICITLY_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_ABSTRACT_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_CONST_TAG_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSPossiblyStoredStubImpl.FLAGS_STRUCTURE, HAS_GENERIC_PARAMETERS_FLAG, IS_INTERFACE_FLAG, HAS_CONSTRUCTS_TAG_FLAG, HAS_NAMESPACE_TAG_FLAG, JS_CONTEXT_FLAG, BROWSER_FAMILY_FLAG, IS_CLASS_EXPLICITLY_FLAG, HAS_ABSTRACT_TAG_FLAG, HAS_CONST_TAG_FLAG);
    @NotNull
    private final List<String> myGenericParameters;
    @Nullable
    private final StringRef myNamespaceForGenericParameters;

    public JSDocCommentStubImpl(JSDocComment psi, StubElement parent) {
        super(psi, parent, JSStubElementTypes.DOC_COMMENT);
        List typedefs;
        this.myGenericParameters = psi.getGenericParameters();
        String ns = JSDocumentationUtils.findNameOfClassAppliedTo((PsiComment)psi);
        if (ns == null && !(typedefs = psi.getTypedefs()).isEmpty()) {
            ns = (String)((Pair)typedefs.get((int)0)).first;
        }
        this.myNamespaceForGenericParameters = StringRef.fromString((String)ns);
        this.writeFlag(IS_INTERFACE_FLAG, psi.hasInterfaceTag());
        this.writeFlag(HAS_CONSTRUCTS_TAG_FLAG, psi.hasConstructsTag());
        this.writeFlag(JS_CONTEXT_FLAG, psi.getJSContext());
        this.writeFlag(BROWSER_FAMILY_FLAG, psi.getBrowserFamily());
        this.writeFlag(HAS_NAMESPACE_TAG_FLAG, psi.hasNamespaceTag());
        this.writeFlag(HAS_GENERIC_PARAMETERS_FLAG, !this.myGenericParameters.isEmpty());
        this.writeFlag(IS_CLASS_EXPLICITLY_FLAG, this.isClassExplicitly());
        this.writeFlag(HAS_ABSTRACT_TAG_FLAG, psi.hasAbstractTag());
        this.writeFlag(HAS_CONST_TAG_FLAG, psi.hasConstTag());
    }

    public JSDocCommentStubImpl(StubInputStream stream, StubElement stub) throws IOException {
        super(stream, stub, JSStubElementTypes.DOC_COMMENT);
        boolean hasGenericParameters = this.readFlag(HAS_GENERIC_PARAMETERS_FLAG);
        if (hasGenericParameters) {
            int size = DataInputOutputUtil.readINT((DataInput)stream);
            this.myGenericParameters = new SmartList();
            for (int i = 0; i < size; ++i) {
                this.myGenericParameters.add(stream.readName().getString());
            }
        } else {
            this.myGenericParameters = Collections.emptyList();
        }
        this.myNamespaceForGenericParameters = stream.readName();
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_GENERIC_PARAMETERS_FLAG).booleanValue()) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myGenericParameters.size());
            for (String s : this.myGenericParameters) {
                dataStream.writeName(s);
            }
        }
        JSDocCommentStubImpl.writeString(this.myNamespaceForGenericParameters, dataStream);
    }

    public JSDocComment createPsi() {
        return new JSDocCommentImpl(this, (IStubElementType)JSStubElementTypes.DOC_COMMENT);
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        if (!this.myGenericParameters.isEmpty() && this.myNamespaceForGenericParameters != null) {
            sink.occurrence(JSGenericsIndex.KEY, (Object)this.myNamespaceForGenericParameters.getString());
        }
    }

    public boolean hasInterfaceTag() {
        return this.readFlag(IS_INTERFACE_FLAG);
    }

    public boolean hasConstructsTag() {
        return this.readFlag(HAS_CONSTRUCTS_TAG_FLAG);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSDocCommentStubImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.readFlag(JS_CONTEXT_FLAG);
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSDocCommentStubImpl", "getJSContext"));
        }
        return jSContext;
    }

    @NotNull
    public JSDocComment.BrowserFamily getBrowserFamily() {
        JSDocComment.BrowserFamily browserFamily = this.readFlag(BROWSER_FAMILY_FLAG);
        if (browserFamily == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSDocCommentStubImpl", "getBrowserFamily"));
        }
        return browserFamily;
    }

    @NotNull
    public List<String> getGenericParameters() {
        List<String> list = this.myGenericParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSDocCommentStubImpl", "getGenericParameters"));
        }
        return list;
    }

    public boolean hasNamespaceTag() {
        return this.readFlag(HAS_NAMESPACE_TAG_FLAG);
    }

    public boolean isClassExplicitly() {
        return this.readFlag(IS_CLASS_EXPLICITLY_FLAG);
    }

    public boolean hasAbstractTag() {
        return this.readFlag(HAS_ABSTRACT_TAG_FLAG);
    }

    public boolean hasConstTag() {
        return this.readFlag(HAS_CONST_TAG_FLAG);
    }
}

