/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;

public class JSFileStubBuilder
extends DefaultStubBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder");

    public StubElement buildStubTree(final @NotNull PsiFile file) {
        StubElement parentStub;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder", "buildStubTree"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Building stub for " + file.getViewProvider().getVirtualFile().getCanonicalPath() + ", language: " + file.getLanguage());
        }
        if (!((parentStub = this.createStubForFile(file)) instanceof JSFileStubImpl) || !(file instanceof JSFile) || ((JSFileStubImpl)parentStub).getCachedData() != null) {
            return this.buildStubTreeFor((ASTNode)file.getNode(), parentStub);
        }
        final JSFileCachedData cachedData = new JSFileCachedData();
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.processFile((JSFile)file, cachedData);
        }
        new DefaultStubBuilder.StubBuildingWalkingVisitor((ASTNode)file.getNode(), parentStub){
            final JSFileCachedDataEvaluator evaluator;
            {
                super((DefaultStubBuilder)JSFileStubBuilder.this, x0, x1);
                this.evaluator = JSDialectSpecificHandlersFactory.forLanguage(DialectDetector.languageOfElement((PsiElement)file)).newFileCachedDataEvaluator(cachedData);
            }

            protected void visitNode(StubElement parentStub, ASTNode node, boolean immediateParentStubbed) {
                PsiElement element = node.getPsi();
                this.evaluator.startElement(element);
                super.visitNode(parentStub, node, immediateParentStubbed);
                if (node.getLastChildNode() == null) {
                    this.evaluator.finishElement(element);
                    ASTNode nextNode = this.peekNextElement();
                    if (nextNode != null) {
                        ASTNode nextNodeParent = nextNode.getTreeParent();
                        for (ASTNode currentParent = node.getTreeParent(); currentParent != null && currentParent != nextNodeParent; currentParent = currentParent.getTreeParent()) {
                            this.evaluator.finishElement(currentParent.getPsi());
                        }
                    }
                }
            }
        }.buildStubTree();
        ((JSFileStubImpl)parentStub).setCachedData(cachedData);
        return parentStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder", "createStubForFile"));
        }
        if (file instanceof JSFile) {
            JSFileStubImpl jSFileStubImpl = new JSFileStubImpl((JSFile)file);
            if (jSFileStubImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder", "createStubForFile"));
            }
            return jSFileStubImpl;
        }
        StubElement stubElement = super.createStubForFile(file);
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder", "createStubForFile"));
        }
        return stubElement;
    }
}

