/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.JSPropertyStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSPossiblyStoredStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyStubImpl
extends JSQualifiedObjectStubBase<JSProperty>
implements JSPropertyStub {
    private static final BooleanStructureElement TYPE_EXPLICITLY_DECLARED = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INITIALIZER_REFERENCE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INDEXING_DATA_FLAG = JSPossiblyStoredStubImpl.HAS_INDEXING_DATA_FLAG;
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSQualifiedObjectStubBase.FLAGS_STRUCTURE, TYPE_EXPLICITLY_DECLARED, HAS_TYPE_FLAG, HAS_INITIALIZER_REFERENCE_FLAG, HAS_INDEXING_DATA_FLAG);
    @Nullable
    private final JSElementIndexingDataStructure myIndexingData;
    @Nullable
    private final StringRef myInitializerReference;
    @Nullable
    private final StringRef myTypeString;

    public JSPropertyStubImpl(JSProperty psi, StubElement parentStub, JSPropertyElementType type) {
        super(psi, parentStub, type);
        JSElementIndexingData indexingData = psi.getIndexingData();
        this.myIndexingData = indexingData != null && !indexingData.isEmpty() ? indexingData.toStructure() : null;
        this.myInitializerReference = StringRef.fromString((String)psi.getInitializerReference());
        JSType jsType = psi.getType();
        this.myTypeString = StringRef.fromString(jsType != null ? jsType.getTypeText(JSType.TypeTextFormat.SERIALIZED) : null);
        this.writeFlag(HAS_TYPE_FLAG, jsType != null);
        this.writeFlag(TYPE_EXPLICITLY_DECLARED, jsType != null && jsType.getSource().isExplicitlyDeclared());
        this.writeFlag(HAS_INITIALIZER_REFERENCE_FLAG, this.myInitializerReference != null);
        this.writeFlag(HAS_INDEXING_DATA_FLAG, this.myIndexingData != null);
    }

    public JSPropertyStubImpl(StubInputStream stream, StubElement parentStub, JSPropertyElementType type) throws IOException {
        super(stream, parentStub, (IStubElementType)type);
        this.myIndexingData = this.readFlag(HAS_INDEXING_DATA_FLAG) != false ? JSElementIndexingDataStructureImpl.deserialize(stream) : null;
        this.myInitializerReference = this.readFlag(HAS_INITIALIZER_REFERENCE_FLAG) != false ? stream.readName() : null;
        this.myTypeString = this.readFlag(HAS_TYPE_FLAG) != false ? stream.readName() : null;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_INDEXING_DATA_FLAG).booleanValue()) {
            JSElementIndexingDataStructureImpl.serialize(this.myIndexingData, dataStream);
        }
        if (this.readFlag(HAS_INITIALIZER_REFERENCE_FLAG).booleanValue()) {
            JSPropertyStubImpl.writeString(this.myInitializerReference, dataStream);
        }
        if (this.readFlag(HAS_TYPE_FLAG).booleanValue()) {
            JSPropertyStubImpl.writeString(this.myTypeString, dataStream);
        }
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSPropertyStubImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }

    public JSProperty createPsi() {
        return new JSPropertyImpl(this);
    }

    @Nullable
    public JSElementIndexingDataStructure getIndexingDataStructure() {
        return this.myIndexingData;
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        JSElementIndexingDataStructureImpl.index(this.myIndexingData, sink);
    }

    @Nullable
    public String getInitializerReference() {
        return StringRef.toString((StringRef)this.myInitializerReference);
    }

    @Nullable
    public String getTypeString() {
        return StringRef.toString((StringRef)this.myTypeString);
    }

    public boolean isTypeExplicitlyDeclared() {
        return this.readFlag(TYPE_EXPLICITLY_DECLARED);
    }

    @Override
    protected boolean doIndexGlobalSymbol() {
        return CommonJSUtil.isExportNamespace(this.getNamespace());
    }

    @Override
    public boolean isExported() {
        return false;
    }

    @Override
    public boolean isExportedWithDefault() {
        return false;
    }
}

