/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSSpecialNamedTypeImpl
extends JSNamedType {
    protected JSSpecialNamedTypeImpl(@Nullable JSTypeSource source, JSTypeContext staticOrInstance) {
        super(source, staticOrInstance);
    }

    @Nullable
    static JSType getSpecialType(String typeString, JSTypeSource source, JSTypeContext staticOrInstance) {
        String typeStringUnified = JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(typeString);
        JSSimpleTypeBaseImpl primitiveType = null;
        if ("string".equals(typeString)) {
            primitiveType = new JSStringType(true, source, staticOrInstance);
        } else if ("String".equals(typeStringUnified)) {
            primitiveType = new JSStringType(false, source, staticOrInstance);
        }
        if ("number".equals(typeString)) {
            primitiveType = new JSNumberType(true, source, staticOrInstance);
        } else if ("Number".equals(typeStringUnified)) {
            primitiveType = new JSNumberType(false, source, staticOrInstance);
        }
        if ("boolean".equals(typeString)) {
            primitiveType = new JSBooleanType(true, source, staticOrInstance);
        } else if ("Boolean".equals(typeStringUnified)) {
            primitiveType = new JSBooleanType(false, source, staticOrInstance);
        }
        if ("Object".equals(typeStringUnified)) {
            primitiveType = new JSObjectType(source, staticOrInstance);
        }
        if ("Function".equals(typeStringUnified)) {
            primitiveType = new JSPrimitiveFunctionType(source, staticOrInstance);
        }
        if ("Array".equals(typeStringUnified)) {
            primitiveType = new JSPrimitiveArrayType(source, staticOrInstance);
        }
        if ("symbol".equals(typeStringUnified)) {
            primitiveType = new JSSymbolType(source, staticOrInstance);
        }
        if ("null".equals(typeStringUnified)) {
            primitiveType = new JSNullType(source);
        }
        if ("undefined".equals(typeStringUnified)) {
            primitiveType = new JSUndefinedType(source);
        }
        if ("void".equals(typeStringUnified)) {
            primitiveType = new JSVoidType(source);
        }
        if (!source.isTypeScript()) {
            if ("int".equals(typeString)) {
                primitiveType = new JSIntType(true, source, staticOrInstance);
            }
            if ("Integer".equals(typeString)) {
                primitiveType = new JSIntType(false, source, staticOrInstance);
            }
            if ("uint".equals(typeStringUnified)) {
                primitiveType = new JSUintType(source, staticOrInstance);
            }
        } else {
            if ("never".equals(typeStringUnified)) {
                primitiveType = new TypeScriptNeverType(source);
            }
            if ("object".equals(typeStringUnified)) {
                primitiveType = JSAnyType.getWithLanguage(JSTypeSource.SourceLanguage.TS, true);
            }
        }
        return primitiveType;
    }

    @Override
    public JSClass resolveClass() {
        if (!this.isEcma()) {
            return null;
        }
        PsiElement clazz = JSResolveUtil.findType(JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(this.getResolvedTypeText()), (PsiElement)this.getScope(), this.isEcma());
        return clazz instanceof JSClass ? (JSClass)clazz : null;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (elementType instanceof JSUndefinedType && this.isJavaScript()) {
            return false;
        }
        if (elementType instanceof JSSpecialNamedTypeImpl) {
            return this.isEquivalentTo(elementType, processingContext);
        }
        if (elementType instanceof JSTypeImpl && ((JSTypeImpl)elementType).isEnum()) {
            return this instanceof JSNumberType;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        JSTypeCastUtil.AssignableResult result = super.isDirectlyAssignableTypeCommon(elementType, processingContext);
        if (result.isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result;
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        if (elementType instanceof JSTypeImpl) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.getTypeHelper().areNamedTypesAssignable(this, (JSNamedType)elementType, processingContext));
            if (assignableResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl", "isDirectlyAssignableTypeCommon"));
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = result;
        if (assignableResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl", "isDirectlyAssignableTypeCommon"));
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType jsType, ProcessingContext processingContext, boolean allowResolve) {
        if (jsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsType", "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl", "isEquivalentToImpl"));
        }
        return jsType.getClass() == ((Object)((Object)this)).getClass();
    }
}

