/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetDefinitionCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptSignatureHelpCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSignatureHelpResponse;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceEvents {
    @NotNull
    private final Project myProject;

    public static TypeScriptLanguageServiceEvents getService(Project project) {
        return (TypeScriptLanguageServiceEvents)ServiceManager.getService((Project)project, TypeScriptLanguageServiceEvents.class);
    }

    public TypeScriptLanguageServiceEvents(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "<init>"));
        }
        this.myProject = project;
    }

    @Nullable
    public Future<TypeScriptSignatureHelpResponse> getSignatureHelp(VirtualFile file, Editor editor, int offset) {
        TypeScriptFileLocationRequestArgs args = new TypeScriptFileLocationRequestArgs();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, file, editor.getDocument(), offset);
        JSLanguageServiceCommandProcessor<TypeScriptSignatureHelpResponse> processor = new JSLanguageServiceCommandProcessor<TypeScriptSignatureHelpResponse>(){

            @Override
            @Nullable
            public TypeScriptSignatureHelpResponse process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$1", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$1", "process"));
                }
                JsonObject element = answer.getElement();
                JsonObject body = element.getAsJsonObject("body");
                if (body == null) {
                    return null;
                }
                return (TypeScriptSignatureHelpResponse)JSLanguageServiceQueue.GSON.fromJson((JsonElement)body, TypeScriptSignatureHelpResponse.class);
            }
        };
        TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(this.myProject, file);
        if (service == null || !service.isServiceCreated()) {
            return null;
        }
        return service.sendCommand(new TypeScriptSignatureHelpCommand(args), processor);
    }

    @Nullable
    public Future<TypeScriptResponseCommon.FileSpan[]> getDeclaration(@NotNull PsiElement sourceElement, @NotNull Document document) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "getDeclaration"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "getDeclaration"));
        }
        VirtualFile file = sourceElement.getContainingFile().getVirtualFile();
        if (file == null) {
            return null;
        }
        TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(this.myProject, file);
        if (service == null || !service.isServiceCreated()) {
            return null;
        }
        TypeScriptFileLocationRequestArgs args = new TypeScriptFileLocationRequestArgs();
        int offset = sourceElement.getTextRange().getStartOffset();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, file, document, offset);
        TypeScriptGetDefinitionCommand command = new TypeScriptGetDefinitionCommand(args);
        return service.sendCommand(command, new JSLanguageServiceCommandProcessor<TypeScriptResponseCommon.FileSpan[]>(){

            @Override
            @NotNull
            public TypeScriptResponseCommon.FileSpan[] process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$2", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$2", "process"));
                }
                JsonObject element = answer.getElement();
                JsonElement jsonElement = element.get("body");
                if (jsonElement == null) {
                    if (TypeScriptResponseCommon.EMPTY_SPAN_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$2", "process"));
                    }
                    return TypeScriptResponseCommon.EMPTY_SPAN_ARRAY;
                }
                TypeScriptResponseCommon.FileSpan[] result = (TypeScriptResponseCommon.FileSpan[])JSLanguageServiceQueue.GSON.fromJson(jsonElement, TypeScriptResponseCommon.FileSpan[].class);
                if (result != null) {
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$2", "process"));
                    }
                    return result;
                }
                if (TypeScriptResponseCommon.EMPTY_SPAN_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$2", "process"));
                }
                return TypeScriptResponseCommon.EMPTY_SPAN_ARRAY;
            }
        });
    }
}

