/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSExportedMembersIndex;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptCompletionUtil {
    public static void addAllVariants(@NotNull JSReferenceExpression expression, @NotNull PsiFile containingFile, @NotNull Iterable sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        if (sinkResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sinkResults", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        if (completionResultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionResultSet", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "addAllVariants"));
        }
        assert (expression.getQualifier() == null);
        THashSet<PsiElement> addedElements = TypeScriptCompletionUtil.getProcessedElements(sinkResults);
        Project project = containingFile.getProject();
        JSInsertHandler<LookupElement> handler = TypeScriptCompletionUtil.createImportInsertHandler();
        TypeScriptAutoImportUtil.JSReferencePlaceInfo info = new TypeScriptAutoImportUtil.JSReferencePlaceInfo((PsiElement)expression);
        MultiMap symbolsToImport = MultiMap.createSet();
        ArrayList needToCheckConfigAccess = ContainerUtil.newArrayList();
        GlobalSearchScope scope = TypeScriptAutoImportUtil.createSymbolToImportSearchScope((PsiElement)containingFile, project);
        PrefixMatcher prefixMatcher = completionResultSet.getPrefixMatcher();
        Processor processor = element -> {
            if (completionResultSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionResultSet", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "lambda$addAllVariants$0"));
            }
            if (!addedElements.contains(element)) {
                String name = element.getName();
                if (name == null || !prefixMatcher.prefixMatches(name)) {
                    return true;
                }
                if (TypeScriptAutoImportUtil.isAvailableForImport((JSElement)element, info, project)) {
                    Collection classes = symbolsToImport.get((Object)name);
                    if (classes.contains(element.getClass())) {
                        return true;
                    }
                    Class<?> elementClass = element.getClass();
                    symbolsToImport.putValue((Object)name, elementClass);
                    PsiFile file = element.getContainingFile();
                    if (file instanceof JSFile && ((JSFile)file).isCommonJSModule()) {
                        LookupElement item = TypeScriptCompletionUtil.createLookupElement(project, name, (PsiElement)element, handler);
                        completionResultSet.addElement(item);
                    } else {
                        needToCheckConfigAccess.add(element);
                    }
                }
            }
            return true;
        };
        TypeScriptCompletionUtil.processExportedElementsForKey(project, "exp", scope, (Processor<JSPsiElementBase>)processor);
        TypeScriptCompletionUtil.processExportedElementsForKey(project, "def", scope, (Processor<JSPsiElementBase>)processor);
        needToCheckConfigAccess.forEach(element -> {
            if (completionResultSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionResultSet", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "lambda$addAllVariants$1"));
            }
            if (TypeScriptConfigService.Provider.isAccessible(project, info.getFile(), element.getContainingFile().getVirtualFile())) {
                String name = element.getName();
                assert (name != null);
                LookupElement item = TypeScriptCompletionUtil.createLookupElement(project, name, (PsiElement)element, handler);
                completionResultSet.addElement(item);
            }
        });
    }

    @NotNull
    public static THashSet<PsiElement> getProcessedElements(@NotNull Iterable sinkResults) {
        if (sinkResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sinkResults", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "getProcessedElements"));
        }
        THashSet addedElements = new THashSet();
        for (Object object : sinkResults) {
            PsiElement sinkResult;
            if (object instanceof LookupElement) {
                sinkResult = ((LookupElement)object).getPsiElement();
            } else {
                if (!(object instanceof PsiElement)) continue;
                sinkResult = (PsiElement)object;
            }
            if (sinkResult instanceof ES6ImportExportSpecifier) {
                ResolveResult[] results;
                for (ResolveResult result : results = ((ES6ImportExportSpecifier)sinkResult).multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (element == null) continue;
                    addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)element));
                }
                continue;
            }
            if (sinkResult == null) continue;
            addedElements.add((Object)CompletionUtil.getOriginalOrSelf((PsiElement)sinkResult));
        }
        THashSet tHashSet = addedElements;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "getProcessedElements"));
        }
        return tHashSet;
    }

    private static void processExportedElementsForKey(Project project, String key, GlobalSearchScope scope, Processor<JSPsiElementBase> processor) {
        StubIndex.getInstance().processElements(JSExportedMembersIndex.KEY, (Object)key, project, scope, JSPsiElementBase.class, processor);
    }

    private static LookupElement createLookupElement(@NotNull Project project, @NotNull String name, @NotNull PsiElement element, @NotNull InsertHandler<LookupElement> handler) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createLookupElement"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createLookupElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createLookupElement"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createLookupElement"));
        }
        return JSCompletionUtil.withJSLookupPriority((LookupElement)LookupElementBuilder.create((String)name).withInsertHandler(handler).withIcon(JSLookupUtilImpl.getIcon(element, false)), JSLookupPriority.NO_RELEVANT_NO_SMARTNESS_PRIORITY);
    }

    @NotNull
    public static JSInsertHandler<LookupElement> createImportInsertHandler() {
        JSInsertHandler<LookupElement> jSInsertHandler = new JSInsertHandler<LookupElement>(){

            @Override
            public void handleInsert(InsertionContext context, LookupElement item) {
                super.handleInsert(context, item);
                if (!JSApplicationSettings.getInstance().isShowTypeScriptAutoImport()) {
                    return;
                }
                CaretModel model = context.getEditor().getCaretModel();
                if (model.getCaretCount() > 1 && model.getPrimaryCaret() != model.getCurrentCaret()) {
                    return;
                }
                PsiElement originalElement = context.getFile().findElementAt(context.getStartOffset());
                if (originalElement != null) {
                    String name = item.getLookupString();
                    PsiElement psiElement = item.getPsiElement();
                    if (psiElement instanceof JSQualifiedNamedElement) {
                        JSQualifiedNamedElement element = (JSQualifiedNamedElement)psiElement;
                        TypeScriptAutoImportUtil.addImportStatement(element.getName(), element, originalElement);
                    } else {
                        new TypeScriptAddImportStatementFix.ImportAction(context.getEditor(), originalElement, name, false).execute();
                    }
                }
            }
        };
        if (jSInsertHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/completion/TypeScriptCompletionUtil", "createImportInsertHandler"));
        }
        return jSInsertHandler;
    }
}

