/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.typescript.inspection.TypeScriptPreferShortImportInspection;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;

public class TypeScriptUMDGlobalInspection
extends JSInspection {
    public static final String SHORT_NAME = TypeScriptUMDGlobalInspection.calcShortNameFromClass(TypeScriptPreferShortImportInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection$1", "visitJSReferenceExpression"));
                }
                DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)node);
                if (node.getQualifier() != null || optionHolder == null || !optionHolder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
                    return;
                }
                TypeScriptUMDGlobalInspection.processUnqualifiedReferenceExpression(holder, node);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static void processUnqualifiedReferenceExpression(@NotNull ProblemsHolder holder, @NotNull JSReferenceExpression node) {
        PsiElement element;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection", "processUnqualifiedReferenceExpression"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection", "processUnqualifiedReferenceExpression"));
        }
        ResolveResult[] results = node.multiResolve(false);
        if (results.length != 1) {
            return;
        }
        ResolveResult result = results[0];
        if (result.isValidResult() && (element = result.getElement()) instanceof TypeScriptGlobalModuleExportDeclaration) {
            TypeScriptUMDGlobalInspection.processGlobalModuleExportDeclaration(holder, node, (TypeScriptGlobalModuleExportDeclaration)element);
        }
    }

    private static void processGlobalModuleExportDeclaration(@NotNull ProblemsHolder holder, @NotNull JSReferenceExpression context, @NotNull TypeScriptGlobalModuleExportDeclaration exportDeclaration) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection", "processGlobalModuleExportDeclaration"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection", "processGlobalModuleExportDeclaration"));
        }
        if (exportDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportDeclaration", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection", "processGlobalModuleExportDeclaration"));
        }
        boolean isCurrentFileModule = ES6PsiUtil.isExternalModule((PsiElement)context.getContainingFile());
        ProblemHighlightType type = isCurrentFileModule ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
        holder.registerProblem((PsiElement)context, JSBundle.message((String)"typescript.reference.to.umd.global", (Object[])new Object[0]), type, new LocalQuickFix[]{new TypeScriptAddImportStatementFix(exportDeclaration.getName(), (PsiElement)context, true, false)});
    }
}

