/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddImportStatementFix
extends LocalQuickFixOnPsiElement
implements HintAction,
HighPriorityAction {
    private final String myName;
    private final boolean myResolved;
    protected volatile boolean myNeedHint;
    private static final Key<Boolean> NO_HINT_KEY = Key.create((String)"Typescript.auto.import.no.hint");

    public TypeScriptAddImportStatementFix(String name, @NotNull PsiElement context, boolean isResolved, boolean needHint) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "<init>"));
        }
        super(context);
        this.myName = name;
        this.myResolved = isResolved;
        this.myNeedHint = needHint;
    }

    public TypeScriptAddImportStatementFix(String name, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "<init>"));
        }
        this(name, context, false, true);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TypeScriptAutoImportUtil.getActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "isAvailable"));
        }
        PsiElement element = this.getStartElement();
        List<JSQualifiedNamedElement> candidates = TypeScriptAddImportStatementFix.getCandidates(this.getNameElement(), element, this.myResolved, this.getFilter());
        return !candidates.isEmpty();
    }

    private static boolean checkReferenceExpressionAcceptable(JSReferenceExpression referenceExpression, boolean resolved) {
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        if (resolved) {
            return true;
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        boolean hasValidResult = false;
        for (ResolveResult result : results) {
            if (!result.isValidResult()) continue;
            hasValidResult = true;
            break;
        }
        return !hasValidResult;
    }

    @NotNull
    protected FilterElementFunction getFilter() {
        FilterElementFunction filterElementFunction = TypeScriptAddImportStatementFix::filterByContext;
        if (filterElementFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getFilter"));
        }
        return filterElementFunction;
    }

    @NotNull
    private static List<JSQualifiedNamedElement> getCandidates(String name, @Nullable PsiElement element, boolean skipRefExpressionResolveCheck, @NotNull FilterElementFunction filterFunction) {
        if (filterFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterFunction", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (element == null || !element.isValid()) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        Project project = element.getProject();
        if (DumbService.isDumb((Project)project) || project.isDisposed()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        if (element instanceof JSReferenceExpression && !TypeScriptAddImportStatementFix.checkReferenceExpressionAcceptable((JSReferenceExpression)element, skipRefExpressionResolveCheck)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        if (name == null) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        ArrayList candidates = ContainerUtil.newArrayList();
        TypeScriptAutoImportUtil.JSReferencePlaceInfo info = new TypeScriptAutoImportUtil.JSReferencePlaceInfo(element);
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)name, project, TypeScriptAutoImportUtil.createSymbolToImportSearchScope(element, project), JSElement.class, element1 -> {
            if (TypeScriptAutoImportUtil.isAvailableForImport(element1, info, project)) {
                candidates.add((JSQualifiedNamedElement)element1);
            }
            return true;
        });
        for (TypeScriptModule module : TypeScriptUtil.getAllRegularExternalModules(element.getProject(), element)) {
            String moduleName = module.getName();
            if (moduleName == null || !StringUtil.unquoteString((String)moduleName).equalsIgnoreCase(name)) continue;
            candidates.add(module);
            break;
        }
        List<JSQualifiedNamedElement> result = candidates.stream().filter(el -> {
            PsiFile file = el.getContainingFile();
            if (!(file instanceof JSFile)) {
                return false;
            }
            return ((JSFile)file).isCommonJSModule() || TypeScriptConfigService.Provider.isAccessible(project, info.getFile(), file.getVirtualFile());
        }).collect(Collectors.toList());
        List<JSQualifiedNamedElement> list = filterFunction.filterByContext(element, result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
        }
        return list;
    }

    @NotNull
    protected static List<JSQualifiedNamedElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSQualifiedNamedElement> result) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "filterByContext"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "filterByContext"));
        }
        if (result.isEmpty()) {
            List<JSQualifiedNamedElement> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "filterByContext"));
            }
            return list;
        }
        if (context.getNode().getElementType() == JSTokenTypes.XML_TAG_NAME) {
            List exactComponents = ContainerUtil.emptyList();
            List<JSQualifiedNamedElement> list = result.stream().filter(el -> ReactXmlExtension.isPossibleReactComponent((PsiElement)el, exactComponents)).collect(Collectors.toList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "filterByContext"));
            }
            return list;
        }
        List<JSQualifiedNamedElement> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "filterByContext"));
        }
        return list;
    }

    private String getNameElement() {
        return this.myName;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        this.createAction(editor, this.myResolved).execute();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        List<JSQualifiedNamedElement> candidates = TypeScriptAddImportStatementFix.getCandidates(this.getNameElement(), startElement, this.myResolved, this.getFilter());
        if (candidates.size() == 1) {
            TypeScriptAutoImportUtil.addImportStatement(this.myName, (JSQualifiedNamedElement)candidates.iterator().next(), startElement);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "showHint"));
        }
        if (!JSApplicationSettings.getInstance().isShowTypeScriptAutoImport() || !this.myNeedHint) {
            return false;
        }
        PsiElement element = this.getStartElement();
        if (element == null || Boolean.TRUE.equals(element.getUserData(NO_HINT_KEY))) {
            return false;
        }
        List<JSQualifiedNamedElement> candidates = TypeScriptAddImportStatementFix.getCandidates(this.getNameElement(), element, false, this.getFilter());
        if (candidates.isEmpty()) {
            return true;
        }
        JSQualifiedNamedElement first = (JSQualifiedNamedElement)ContainerUtil.getFirstItem(candidates);
        assert (first != null);
        String nameToShow = new JSQualifiedNamedElementRenderer<JSQualifiedNamedElement>().getElementText(first) + " " + JSQualifiedNamedElementRenderer.getContainerText(first);
        String message = ShowAutoImportPass.getMessage((candidates.size() > 1 ? 1 : 0) != 0, (String)nameToShow);
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), (QuestionAction)this.createAction(editor, false));
        return true;
    }

    @NotNull
    public ImportAction createAction(@NotNull Editor editor, boolean resolved) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "createAction"));
        }
        ImportAction importAction = new ImportAction(editor, this.getStartElement(), this.getNameElement(), resolved, this.getFilter()){

            @Override
            protected void runAction(@Nullable Editor editor, String name, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
                if (elementToImport == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$1", "runAction"));
                }
                if (place == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$1", "runAction"));
                }
                super.runAction(editor, name, elementToImport, place);
                TypeScriptAddImportStatementFix.this.myNeedHint = false;
            }
        };
        if (importAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "createAction"));
        }
        return importAction;
    }

    @NotNull
    private static List<JSQualifiedNamedElement> removeMergedElements(@NotNull List<JSQualifiedNamedElement> candidates, @NotNull Collection<JSQualifiedNamedElement> elementsFromLibraries) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeMergedElements"));
        }
        if (elementsFromLibraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsFromLibraries", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeMergedElements"));
        }
        HashSet qNames = ContainerUtil.newHashSet();
        HashSet toRemove = ContainerUtil.newHashSet();
        for (JSQualifiedNamedElement candidate : candidates) {
            PsiElement module;
            String qName;
            if (elementsFromLibraries.contains(candidate) || StringUtil.isEmpty((String)(qName = JSQualifiedNamedElementRenderer.getQualifiedName(candidate))) || (module = TypeScriptPsiUtil.findExternalModule((PsiElement)candidate)) != null || qNames.add(qName)) continue;
            toRemove.add(candidate);
        }
        if (toRemove.isEmpty()) {
            List<JSQualifiedNamedElement> list = candidates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeMergedElements"));
            }
            return list;
        }
        List<JSQualifiedNamedElement> list = candidates.stream().filter(el -> !toRemove.contains(el)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeMergedElements"));
        }
        return list;
    }

    private static List<JSQualifiedNamedElement> removeSimilarLibraryModules(@NotNull List<JSQualifiedNamedElement> candidates, @NotNull Map<PsiElement, TypeScriptAutoImportUtil.ModuleInfo> calculatedModules) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeSimilarLibraryModules"));
        }
        if (calculatedModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculatedModules", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "removeSimilarLibraryModules"));
        }
        if (calculatedModules.isEmpty() || calculatedModules.size() == 1) {
            return candidates;
        }
        HashSet toRemove = ContainerUtil.newHashSet();
        Set<Map.Entry<PsiElement, TypeScriptAutoImportUtil.ModuleInfo>> entries = calculatedModules.entrySet();
        ArrayList toIterate = ContainerUtil.newArrayList(calculatedModules.entrySet());
        HashSet uniqueModuleNamesForSymbols = ContainerUtil.newHashSet();
        HashSet uniqueModuleNamesForModules = ContainerUtil.newHashSet();
        entries.forEach(entry -> {
            TypeScriptAutoImportUtil.ModuleInfo moduleInfo = (TypeScriptAutoImportUtil.ModuleInfo)entry.getValue();
            VirtualFile pathFile = moduleInfo.getPathFile();
            PsiElement elementToImport = (PsiElement)entry.getKey();
            String pathText = pathFile.getPath();
            if (!StringUtil.isEmpty((String)pathText)) {
                if (elementToImport instanceof TypeScriptModule) {
                    if (!uniqueModuleNamesForModules.add(pathText)) {
                        toRemove.add(elementToImport);
                    }
                } else if (!uniqueModuleNamesForSymbols.add(pathText)) {
                    toRemove.add(elementToImport);
                }
            }
            if (pathFile.isDirectory()) {
                toIterate.forEach(second -> {
                    TypeScriptAutoImportUtil.ModuleInfo secondModuleInfo = (TypeScriptAutoImportUtil.ModuleInfo)second.getValue();
                    VirtualFile secondModuleInfoPathFile = secondModuleInfo.getPathFile();
                    if (secondModuleInfoPathFile.isDirectory() && VfsUtilCore.isAncestor((VirtualFile)secondModuleInfoPathFile, (VirtualFile)pathFile, (boolean)true) && secondModuleInfoPathFile.findChild("package.json") != null) {
                        toRemove.add(elementToImport);
                    }
                });
            }
        });
        return candidates.stream().filter(el -> !toRemove.contains(el)).collect(Collectors.toList());
    }

    private static Collection<JSQualifiedNamedElement> getElementsFromLibraries(Collection<JSQualifiedNamedElement> candidates, Project project) {
        return candidates.stream().filter(element -> {
            PsiFile file = element.getContainingFile();
            if (file instanceof JSFile && ((JSFile)file).isCommonJSModule()) {
                VirtualFile fileToSearch = file.getVirtualFile();
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
                if (virtualFile != null) {
                    Pair<VirtualFile, VirtualFile> parentLibraryDirectory = TypeScriptAutoImportUtil.findParentLibraryDirectory(project, fileToSearch, JSLibraryUtil.LIBRARY_DIR_NAMES);
                    return parentLibraryDirectory != null;
                }
            }
            return false;
        }).collect(Collectors.toList());
    }

    public static class ImportAction
    implements QuestionAction {
        @NotNull
        private final Editor myEditor;
        private final String myName;
        private final boolean mySkipRefExpressionResolveCheck;
        @Nullable
        private final PsiElement myStartElement;
        private final FilterElementFunction myFilter;

        public ImportAction(@NotNull Editor editor, @Nullable PsiElement startElement, String name, boolean isResolved) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "<init>"));
            }
            this(editor, startElement, name, isResolved, TypeScriptAddImportStatementFix::filterByContext);
        }

        public ImportAction(@NotNull Editor editor, @Nullable PsiElement startElement, String name, boolean isResolved, @NotNull FilterElementFunction filter) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "<init>"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "<init>"));
            }
            this.myStartElement = startElement;
            this.myEditor = editor;
            this.myName = name;
            this.mySkipRefExpressionResolveCheck = isResolved;
            this.myFilter = filter;
        }

        public boolean execute() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myStartElement == null) {
                return true;
            }
            List candidates = TypeScriptAddImportStatementFix.getCandidates(this.myName, this.myStartElement, this.mySkipRefExpressionResolveCheck, this.myFilter);
            if (candidates.isEmpty()) {
                return true;
            }
            if (candidates.size() == 1) {
                this.addImport(candidates);
            } else {
                HashMap preRenderedQNames = ContainerUtil.newHashMap();
                Project project = this.myStartElement.getProject();
                Collection elementsFromLibraries = TypeScriptAddImportStatementFix.getElementsFromLibraries(candidates, project);
                PsiFile file = this.myStartElement.getContainingFile();
                if (elementsFromLibraries.isEmpty()) {
                    List<JSQualifiedNamedElement> finalElements = ImportAction.getFinalElementsList(project, file, candidates, elementsFromLibraries, preRenderedQNames);
                    if (finalElements.size() == 1) {
                        this.addImport(candidates);
                    } else {
                        this.showPopup(finalElements, preRenderedQNames);
                    }
                    return true;
                }
                Runnable calcModuleNamesAndShowPopupIfNecessary = () -> {
                    List newCandidates = (List)ReadAction.compute(() -> ImportAction.getFinalElementsList(project, file, candidates, elementsFromLibraries, preRenderedQNames));
                    TransactionGuard.submitTransaction((Disposable)project, () -> {
                        this.setNoHintFlag(false);
                        if (newCandidates.isEmpty() || !this.myStartElement.isValid()) {
                            return;
                        }
                        if (newCandidates.size() == 1) {
                            JSQualifiedNamedElement item = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((List)newCandidates);
                            assert (item != null);
                            if (!item.isValid()) {
                                return;
                            }
                            Runnable runnable = () -> this.runAction(this.myEditor, this.myName, item, this.myStartElement);
                            CommandProcessor.getInstance().executeCommand(item.getProject(), runnable, this.getClass().getName(), (Object)this);
                            return;
                        }
                        this.showPopup(newCandidates, preRenderedQNames);
                    });
                };
                this.setNoHintFlag(true);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    calcModuleNamesAndShowPopupIfNecessary.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(calcModuleNamesAndShowPopupIfNecessary);
                }
            }
            return true;
        }

        private void setNoHintFlag(boolean value) {
            if (this.myStartElement == null) {
                return;
            }
            PsiElement toSet = this.myStartElement;
            if (this.myStartElement.getNode().getElementType() == JSTokenTypes.IDENTIFIER) {
                toSet = this.myStartElement.getParent();
            }
            toSet.putUserData(NO_HINT_KEY, (Object)value);
        }

        private void addImport(List<JSQualifiedNamedElement> candidates) {
            JSQualifiedNamedElement candidate = candidates.iterator().next();
            this.runAction(this.myEditor, this.myName, candidate, this.myStartElement);
        }

        protected void runAction(@Nullable Editor editor, String name, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
            if (elementToImport == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "runAction"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "runAction"));
            }
            TypeScriptAutoImportUtil.addImportStatement(editor, name, elementToImport, place);
        }

        private static List<JSQualifiedNamedElement> getFinalElementsList(@NotNull Project project, @NotNull PsiFile file, @NotNull List<JSQualifiedNamedElement> candidates, @NotNull Collection<JSQualifiedNamedElement> elementsFromLibraries, @NotNull Map<PsiElement, String> renderedTexts) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (elementsFromLibraries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsFromLibraries", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (renderedTexts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderedTexts", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "getFinalElementsList"));
            }
            if (!file.isValid() || project.isDisposed() || !project.isOpen()) {
                return ContainerUtil.emptyList();
            }
            candidates = TypeScriptAddImportStatementFix.removeMergedElements(candidates, elementsFromLibraries);
            if (elementsFromLibraries.isEmpty()) {
                return candidates;
            }
            HashMap modulesInfos = ContainerUtil.newHashMap();
            ImportAction.fillExternalModuleNames(project, modulesInfos, elementsFromLibraries, file, candidates);
            modulesInfos.forEach((el, info) -> {
                if (renderedTexts == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderedTexts", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "lambda$getFinalElementsList$4"));
                }
                renderedTexts.put((PsiElement)el, info.getPath());
            });
            return TypeScriptAddImportStatementFix.removeSimilarLibraryModules(candidates, modulesInfos);
        }

        private void showPopup(@NotNull List<JSQualifiedNamedElement> candidates, final @NotNull Map<PsiElement, String> preRenderedQNames) {
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "showPopup"));
            }
            if (preRenderedQNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preRenderedQNames", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "showPopup"));
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])candidates.toArray(new JSQualifiedNamedElement[candidates.size()])), (PsiElementListCellRenderer)new JSQualifiedNamedElementRenderer<JSQualifiedNamedElement>(){

                @Override
                protected String getContainerText(JSQualifiedNamedElement element, String name) {
                    String preRenderedQName = (String)preRenderedQNames.get(element);
                    if (!StringUtil.isEmpty((String)preRenderedQName)) {
                        return "(" + preRenderedQName + ")";
                    }
                    return super.getContainerText(element, name);
                }
            }, (String)JSBundle.message((String)"choose.class.to.import.title", (Object[])new Object[0]), (PsiElementProcessor)new PsiElementProcessor<JSQualifiedNamedElement>(){

                public boolean execute(@NotNull JSQualifiedNamedElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction$2", "execute"));
                    }
                    CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction$2", "lambda$execute$0"));
                        }
                        if (myStartElement == null || !myStartElement.isValid() || !element.isValid()) {
                            return;
                        }
                        this.runAction(myEditor, myName, element, myStartElement);
                    }, this.getClass().getName(), (Object)this);
                    return false;
                }
            }).showInBestPositionFor(this.myEditor);
        }

        private static void fillExternalModuleNames(@NotNull Project project, @NotNull Map<PsiElement, TypeScriptAutoImportUtil.ModuleInfo> renderedText, @NotNull Collection<JSQualifiedNamedElement> elementsFromLibraries, @NotNull PsiFile file, @NotNull List<JSQualifiedNamedElement> candidates) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            if (renderedText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderedText", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            if (elementsFromLibraries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsFromLibraries", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            if (candidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "fillExternalModuleNames"));
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (JSQualifiedNamedElement element : elementsFromLibraries) {
                TypeScriptAutoImportUtil.ModuleInfo nameToModule = TypeScriptAutoImportUtil.getExternalFileModuleName(project, element, (PsiElement)file);
                if (nameToModule == null) continue;
                renderedText.put((PsiElement)element, nameToModule);
            }
        }
    }

    public static interface FilterElementFunction {
        @NotNull
        public List<JSQualifiedNamedElement> filterByContext(@NotNull PsiElement var1, @NotNull List<JSQualifiedNamedElement> var2);
    }
}

