/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.spring.contexts.model.SpringCachingProcessor;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.search.SpringBeanSearchParameters;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SpringExecutorsQueryCachingProcessor<InParams extends SpringModelSearchParameters, OutParams extends SpringBeanSearchParameters>
extends SpringCachingProcessor<InParams> {
    SpringExecutorsQueryCachingProcessor() {
    }

    @NotNull
    protected Collection<SpringBeanPointer> findPointers(@NotNull InParams parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/contexts/model/SpringExecutorsQueryCachingProcessor", "findPointers"));
        }
        ExecutorsQuery<SpringBeanPointer, OutParams> query = this.createQuery(parameters);
        SmartList results = new SmartList();
        Processor collectProcessor = Processors.cancelableCollectProcessor((Collection)results);
        query.forEach(collectProcessor);
        SmartList smartList = results.isEmpty() ? Collections.emptyList() : results;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringExecutorsQueryCachingProcessor", "findPointers"));
        }
        return smartList;
    }

    @Nullable
    protected SpringBeanPointer findFirstPointer(@NotNull InParams parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/contexts/model/SpringExecutorsQueryCachingProcessor", "findFirstPointer"));
        }
        return (SpringBeanPointer)this.createQuery(parameters).findFirst();
    }

    protected abstract ExecutorsQuery<SpringBeanPointer, OutParams> createQuery(InParams var1);
}

