/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringOuterModelsModificationTracker
extends SimpleModificationTracker {
    public SpringOuterModelsModificationTracker(Project project) {
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeAdapter(), (Disposable)project);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new MyVirtualFileAdapter(project)));
    }

    private class MyPsiTreeChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeAdapter() {
        }

        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyPsiTreeChangeAdapter", "beforeChildAddition"));
            }
            this.processChange(event, event.getParent(), event.getChild());
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyPsiTreeChangeAdapter", "childrenChanged"));
            }
            if (event instanceof PsiTreeChangeEventImpl && ((PsiTreeChangeEventImpl)event).isGenericChange()) {
                return;
            }
            this.processChange(event, event.getParent(), event.getChild());
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyPsiTreeChangeAdapter", "beforeChildRemoval"));
            }
            this.processChange(event, event.getParent(), event.getChild());
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyPsiTreeChangeAdapter", "childAdded"));
            }
            this.processChange(event, event.getParent(), event.getChild());
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyPsiTreeChangeAdapter", "childRemoved"));
            }
            this.processChange(event, event.getParent(), event.getChild());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyPsiTreeChangeAdapter", "childReplaced"));
            }
            this.processChange(event, event.getParent(), event.getOldChild());
        }

        private void processChange(PsiTreeChangeEvent event, PsiElement parent, PsiElement child) {
            if (event.getFile() instanceof PropertiesFile) {
                SpringOuterModelsModificationTracker.this.incModificationCount();
                return;
            }
            if (!(event.getFile() instanceof PsiClassOwner)) {
                return;
            }
            if (parent instanceof PsiModifierList && child instanceof PsiAnnotation) {
                this.checkRelevantAnnotation((PsiAnnotation)child);
                return;
            }
            if (parent instanceof PsiClass && child instanceof PsiClass) {
                SpringOuterModelsModificationTracker.this.incModificationCount();
                return;
            }
            if (parent instanceof PsiImportList || child instanceof PsiImportList || PsiTreeUtil.getParentOfType((PsiElement)parent, PsiImportList.class) != null) {
                SpringOuterModelsModificationTracker.this.incModificationCount();
                return;
            }
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiAnnotation.class);
            if (annotation != null) {
                this.checkRelevantAnnotation(annotation);
            }
        }

        private void checkRelevantAnnotation(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyPsiTreeChangeAdapter", "checkRelevantAnnotation"));
            }
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class);
            if (modifierListOwner == null || modifierListOwner instanceof PsiClass || modifierListOwner instanceof PsiMethod) {
                SpringOuterModelsModificationTracker.this.incModificationCount();
            }
        }
    }

    private class MyVirtualFileAdapter
    extends VirtualFileAdapter {
        private final Set<FileType> ignoredFileTypes = ContainerUtil.immutableSet((Object[])new FileType[]{StdFileTypes.HTML, StdFileTypes.JS, StdFileTypes.JSP, StdFileTypes.JSPX});
        private final ProjectFileIndex myFileIndex;

        private MyVirtualFileAdapter(Project project) {
            this.myFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyVirtualFileAdapter", "fileCreated"));
            }
            this.incModificationCountIfMine(event);
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyVirtualFileAdapter", "beforeFileDeletion"));
            }
            this.incModificationCountIfMine(event);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyVirtualFileAdapter", "fileMoved"));
            }
            this.incModificationCountIfMine((VirtualFileEvent)event);
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyVirtualFileAdapter", "propertyChanged"));
            }
            if (event.getPropertyName().equals("name")) {
                this.incModificationCountIfMine((VirtualFileEvent)event);
            }
        }

        private void incModificationCountIfMine(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/impl/SpringOuterModelsModificationTracker$MyVirtualFileAdapter", "incModificationCountIfMine"));
            }
            VirtualFile file = event.getFile();
            if (!this.myFileIndex.isInContent(file)) {
                return;
            }
            if (!file.isDirectory() && this.ignoredFileTypes.contains(file.getFileType())) {
                return;
            }
            SpringOuterModelsModificationTracker.this.incModificationCount();
        }
    }
}

