/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import com.intellij.spring.model.actions.generate.SpringGenerateTemplatesHolder;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.SpringInjection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenerateSpringBeanDependenciesActionHandler
implements CodeInsightActionHandler {
    private final boolean mySetterDependency;

    public GenerateSpringBeanDependenciesActionHandler(boolean setterDependency) {
        this.mySetterDependency = setterDependency;
    }

    public boolean isSetterDependency() {
        return this.mySetterDependency;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/actions/GenerateSpringBeanDependenciesActionHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spring/model/actions/GenerateSpringBeanDependenciesActionHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/model/actions/GenerateSpringBeanDependenciesActionHandler", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element != null) {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            assert (psiClass != null);
            CommonSpringModel psiClassSpringModel = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
            List<Pair<SpringInjection, SpringGenerateTemplatesHolder>> list = GenerateSpringBeanDependenciesUtil.generateDependenciesFor(psiClassSpringModel, psiClass, this.mySetterDependency);
            for (Pair<SpringInjection, SpringGenerateTemplatesHolder> pair : list) {
                ((SpringGenerateTemplatesHolder)pair.getSecond()).runTemplates();
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

