/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.AnnotationSpringModelImpl;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.model.custom.CustomComponentsDiscovererHelper;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringActiveProfiles;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextHierarchy;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class SpringTestingModel
extends SpringModel {
    private Set<String> myActiveProfiles;
    private final PsiClass myTestClass;

    SpringTestingModel(@NotNull PsiClass testClass, @NotNull Module module) {
        if (testClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testClass", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "<init>"));
        }
        super(module);
        this.myTestClass = testClass;
    }

    @NotNull
    public Module getModule() {
        Module module = super.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getModule"));
        }
        return module;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        if (this.myActiveProfiles == null) {
            this.myActiveProfiles = this.discoverTestContextActiveProfiles();
        }
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getActiveProfiles"));
        }
        return set;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getAllProfiles"));
        }
        return set;
    }

    @NotNull
    public Set<CommonSpringModel> getModelsToProcess(boolean checkActiveProfiles) {
        LinkedHashSet testConfigurations = ContainerUtil.newLinkedHashSet();
        LinkedHashSet appContexts = ContainerUtil.newLinkedHashSet();
        LinkedHashSet configurationContexts = ContainerUtil.newLinkedHashSet();
        SpringTestContextUtil testContextUtil = SpringTestContextUtil.getInstance();
        InheritanceUtil.processSupers((PsiClass)this.myTestClass, (boolean)true, psiClass -> {
            ProgressManager.checkCanceled();
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                return true;
            }
            testConfigurations.addAll(SpringTestingModel.getConfigurations(psiClass));
            return true;
        });
        for (ContextConfiguration contextConfiguration : testConfigurations) {
            testContextUtil.discoverConfigFiles(contextConfiguration, (Set)appContexts, (Set)configurationContexts, new PsiClass[]{contextConfiguration.getPsiElement(), this.myTestClass});
        }
        final Set<String> activeProfiles = this.getActiveProfiles();
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        Module module = this.getModule();
        if (!appContexts.isEmpty()) {
            XmlSpringModel xmlModel = SpringCombinedModelFactory.createXmlModel((Collection<XmlFile>)appContexts, module, activeProfiles);
            ContainerUtil.addIfNotNull((Collection)models, (Object)xmlModel);
        }
        if (!configurationContexts.isEmpty()) {
            models.add(new AnnotationSpringModelImpl(configurationContexts, module, null){

                public Set<String> getActiveProfiles() {
                    return activeProfiles;
                }
            });
        }
        if (!module.isDisposed()) {
            ContainerUtil.addAllNotNull((Collection)models, (Iterable)CustomComponentsDiscovererHelper.getInstance((Module)module).getCustomModels());
        }
        for (ContextConfiguration configuration : testConfigurations) {
            for (SpringTestingImplicitContextsProvider provider : (SpringTestingImplicitContextsProvider[])Extensions.getExtensions((ExtensionPointName)SpringTestingImplicitContextsProvider.EP_NAME)) {
                models.addAll(provider.getModels(this.getModule(), configuration));
            }
        }
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getModelsToProcess"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<ContextConfiguration> getConfigurations(@NotNull PsiClass psiClass) {
        SpringContextHierarchy hierarchyConfiguration;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getConfigurations"));
        }
        LinkedHashSet<ContextConfiguration> configurations = new LinkedHashSet<ContextConfiguration>(2);
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        ContextConfiguration contextConfiguration = (ContextConfiguration)jamService.getJamElement(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, (PsiElement)psiClass);
        if (contextConfiguration != null) {
            configurations.add(contextConfiguration);
        }
        if ((hierarchyConfiguration = (SpringContextHierarchy)jamService.getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringContextHierarchy.META})) != null) {
            configurations.addAll(hierarchyConfiguration.getContextConfigurations());
        }
        LinkedHashSet<ContextConfiguration> linkedHashSet = configurations;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "getConfigurations"));
        }
        return linkedHashSet;
    }

    @NotNull
    private Set<String> discoverTestContextActiveProfiles() {
        HashSet activeProfiles = new HashSet();
        InheritanceUtil.processSupers((PsiClass)this.myTestClass, (boolean)true, arg_0 -> SpringTestingModel.lambda$discoverTestContextActiveProfiles$1((Set)activeProfiles, arg_0));
        HashSet hashSet = activeProfiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingModel", "discoverTestContextActiveProfiles"));
        }
        return hashSet;
    }

    private static /* synthetic */ boolean lambda$discoverTestContextActiveProfiles$1(Set activeProfiles, PsiClass psiClass) {
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return true;
        }
        SpringActiveProfiles profiles = SpringContextConfiguration.getSpringActiveProfiles((PsiClass)psiClass);
        if (profiles != null) {
            activeProfiles.addAll(profiles.getActiveProfiles());
        }
        return true;
    }
}

