/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.core;

import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.core.PsiBeanProperty;
import com.intellij.struts.dom.FormProperty;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PsiBeanPropertyImpl
implements PsiBeanProperty,
Comparable<PsiBeanProperty> {
    private final PsiElement[] myPsiElements;
    private final String myName;
    private final String myType;
    private final Icon myIcon;
    private final boolean myHasSetter;
    private final boolean myHasGetter;
    private PsiMethod myGetter;

    public PsiBeanPropertyImpl(@NonNls String name, @NonNls String type) {
        this.myPsiElements = null;
        this.myName = name;
        this.myType = type;
        this.myIcon = AllIcons.Nodes.PropertyWrite;
        this.myHasSetter = true;
        this.myHasGetter = true;
    }

    @Nullable
    public static PsiBeanProperty create(FormProperty formProperty) {
        String name = formProperty.getName().getStringValue();
        return name == null ? null : new PsiBeanPropertyImpl(formProperty);
    }

    private PsiBeanPropertyImpl(FormProperty formProperty) {
        PsiElement[] psiElementArray;
        this.myName = formProperty.getName().getStringValue();
        PsiType type = (PsiType)formProperty.getType().getValue();
        this.myType = type != null ? type.getCanonicalText() : null;
        XmlTag xmlTag = formProperty.getName().getXmlTag();
        if (xmlTag == null) {
            psiElementArray = null;
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = xmlTag;
        }
        this.myPsiElements = psiElementArray;
        this.myIcon = AllIcons.Nodes.PropertyWrite;
        this.myHasSetter = true;
        this.myHasGetter = true;
    }

    public PsiBeanPropertyImpl(PsiClass clazz, String name, @Nullable PsiField field) {
        this.myName = name;
        String myType = null;
        this.myGetter = PropertyUtil.findPropertyGetter((PsiClass)clazz, (String)name, (boolean)false, (boolean)true);
        PsiMethod setter = PropertyUtil.findPropertySetter((PsiClass)clazz, (String)name, (boolean)false, (boolean)true);
        if (this.myGetter != null || setter != null) {
            if (this.myGetter != null && setter != null) {
                this.myIcon = AllIcons.Nodes.PropertyWrite;
                this.myHasSetter = true;
                this.myHasGetter = true;
            } else if (this.myGetter != null) {
                this.myIcon = AllIcons.Nodes.PropertyRead;
                this.myHasGetter = true;
                this.myHasSetter = false;
            } else {
                this.myIcon = AllIcons.Nodes.PropertyWrite;
                this.myHasSetter = true;
                this.myHasGetter = false;
            }
        } else {
            this.myGetter = PropertyUtil.findPropertyGetter((PsiClass)clazz, (String)name, (boolean)true, (boolean)true);
            setter = PropertyUtil.findPropertySetter((PsiClass)clazz, (String)name, (boolean)true, (boolean)true);
            if (this.myGetter != null && setter != null) {
                this.myIcon = AllIcons.Nodes.PropertyReadWriteStatic;
                this.myHasSetter = true;
                this.myHasGetter = true;
            } else if (this.myGetter != null) {
                this.myIcon = AllIcons.Nodes.PropertyReadStatic;
                this.myHasGetter = true;
                this.myHasSetter = false;
            } else {
                this.myIcon = AllIcons.Nodes.PropertyWriteStatic;
                this.myHasSetter = true;
                this.myHasGetter = false;
            }
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        if (field != null) {
            elements.add(field);
            myType = field.getType().getPresentableText();
        }
        if (this.myGetter != null) {
            elements.add(this.myGetter);
            PsiType returnType = this.myGetter.getReturnType();
            assert (returnType != null);
            myType = returnType.getPresentableText();
        }
        if (setter != null) {
            elements.add(setter);
            myType = setter.getParameterList().getParameters()[0].getType().getPresentableText();
        }
        this.myPsiElements = PsiUtilCore.toPsiElementArray(elements);
        this.myType = myType;
    }

    public PsiElement[] getPsiElements() {
        return this.myPsiElements;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getName() {
        return this.myName;
    }

    public String getType() {
        return this.myType;
    }

    public boolean hasGetter() {
        return this.myHasGetter;
    }

    public PsiMethod getGetter() {
        return this.myGetter;
    }

    public boolean hasSetter() {
        return this.myHasSetter;
    }

    public String toString() {
        return this.myName + " (" + this.myType + ")";
    }

    @Override
    public int compareTo(PsiBeanProperty o) {
        return this.myName.compareTo(o.getName());
    }
}

