/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.property;

import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.core.PsiBeanProperty;
import com.intellij.struts.core.PsiBeanPropertyCache;
import com.intellij.struts.inplace.reference.BaseReferenceProvider;
import com.intellij.struts.inplace.reference.XmlValueReference;
import com.intellij.struts.inplace.reference.property.PropertyReferenceSet;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PropertyReference
extends XmlValueReference
implements PsiPolyVariantReference {
    private final PropertyReferenceSet myReferenceSet;
    private final int myIndex;
    private boolean myIndexed;
    private ResolveResult[] last;

    public PropertyReference(PropertyReferenceSet set, int index, TextRange range, BaseReferenceProvider provider) {
        super(set.getValue(), provider, range);
        this.myReferenceSet = set;
        this.myIndex = index;
    }

    @NotNull
    protected abstract PsiBeanProperty[] getPropertiesForTag(boolean var1);

    @Nullable
    private PsiElement getContext() {
        PropertyReference ref = this.getContextReference();
        if (ref == null) {
            return null;
        }
        ResolveResult[] resolveResults = ref.multiResolve(false);
        return resolveResults.length == 0 ? null : resolveResults[0].getElement();
    }

    @Nullable
    private PropertyReference getContextReference() {
        return this.myIndex <= 0 ? null : this.myReferenceSet.getReferences()[this.myIndex - 1];
    }

    @Override
    @NotNull
    public String getValue() {
        this.myIndexed = false;
        String val = super.getValue();
        int pos = val.indexOf(40);
        int pos1 = val.indexOf(41);
        if (pos != -1 && pos1 != -1 && pos1 > pos) {
            String string = val.substring(0, pos);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/PropertyReference", "getValue"));
            }
            return string;
        }
        pos = val.indexOf(91);
        pos1 = val.indexOf(93);
        if (pos != -1 && pos1 != -1 && pos1 > pos) {
            this.myIndexed = true;
            String string = val.substring(0, pos);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/PropertyReference", "getValue"));
            }
            return string;
        }
        String string = val;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/PropertyReference", "getValue"));
        }
        return string;
    }

    @Override
    @Nullable
    protected PsiElement doResolve() {
        ResolveResult[] result = this.multiResolve(false);
        if (result.length == 1) {
            return result[0].getElement();
        }
        return null;
    }

    @Override
    protected Object[] doGetVariants() {
        PsiBeanProperty[] props = this.getProperties(true);
        ArrayList<Object> result = new ArrayList<Object>();
        for (PsiBeanProperty p : props) {
            Object item = LookupValueFactory.createLookupValueWithHint((String)p.getName(), (Icon)p.getIcon(), (String)p.getType());
            result.add(item);
        }
        return result.toArray();
    }

    @Override
    public PsiElement handleElementRename(String string) throws IncorrectOperationException {
        String field;
        if (this.last != null && this.last.length > 0 && (this.last[0].getElement() instanceof PsiField || this.last[0].getElement() instanceof PsiMethod) && (field = PropertyUtil.getPropertyName((String)string)) != null) {
            string = field;
        }
        return super.handleElementRename(string);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        ResolveResult[] result;
        for (ResolveResult aResult : result = this.multiResolve(false)) {
            PsiElement el = aResult.getElement();
            if (!element.getManager().areElementsEquivalent(element, el)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private PsiBeanProperty[] getProperties(boolean forVariants) {
        PsiElement context = this.getContext();
        if (context == null) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myValue, XmlTag.class);
            if (tag != null) {
                PsiBeanProperty[] psiBeanPropertyArray = this.getPropertiesForTag(forVariants);
                if (psiBeanPropertyArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/PropertyReference", "getProperties"));
                }
                return psiBeanPropertyArray;
            }
        } else {
            PsiType type = null;
            if (context instanceof PsiMethod) {
                type = ((PsiMethod)context).getReturnType();
            } else if (context instanceof PsiField) {
                type = ((PsiField)context).getType();
            }
            if (type != null) {
                PropertyReference ref;
                if (type instanceof PsiArrayType && (ref = this.getContextReference()) instanceof PropertyReference && ref.myIndexed) {
                    type = ((PsiArrayType)type).getComponentType();
                }
                if (type instanceof PsiClassType) {
                    PsiBeanProperty[] psiBeanPropertyArray = this.getProperties(((PsiClassType)type).resolve());
                    if (psiBeanPropertyArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/PropertyReference", "getProperties"));
                    }
                    return psiBeanPropertyArray;
                }
            }
        }
        if (PsiBeanProperty.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/PropertyReference", "getProperties"));
        }
        return PsiBeanProperty.EMPTY_ARRAY;
    }

    protected PsiBeanProperty[] getProperties(String className) {
        XmlAttributeValue attributeValue = this.myReferenceSet.getValue();
        PsiClass clazz = JavaPsiFacade.getInstance((Project)attributeValue.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject()));
        return this.getProperties(clazz);
    }

    @NotNull
    private PsiBeanProperty[] getProperties(PsiClass clazz) {
        PsiBeanProperty[] psiBeanPropertyArray = PsiBeanPropertyCache.getInstance(this.getProject()).getBeanProperties(clazz);
        if (psiBeanPropertyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/PropertyReference", "getProperties"));
        }
        return psiBeanPropertyArray;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiBeanProperty[] props;
        ArrayList<PsiElementResolveResult> result = new ArrayList<PsiElementResolveResult>();
        String val = this.getValue();
        for (PsiBeanProperty prop : props = this.getProperties(false)) {
            if (!prop.getName().equals(val)) continue;
            PsiElement[] els = prop.getPsiElements();
            if (els != null) {
                for (PsiElement el : els) {
                    result.add(new PsiElementResolveResult(el));
                }
                break;
            }
            result.add(new PsiElementResolveResult((PsiElement)this.myValue));
            break;
        }
        this.last = result.toArray(new ResolveResult[result.size()]);
        if (this.last == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/PropertyReference", "multiResolve"));
        }
        return this.last;
    }
}

