/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineSuiteStructure
extends AbstractJasmineElement {
    private final JSCallExpression myEnclosingCallExpression;
    private final JSFunctionExpression mySpecDefinitions;
    private final List<JasmineSuiteStructure> mySuiteChildren;
    private final List<JasmineSpecStructure> mySpecChildren;
    private final Map<String, AbstractJasmineElement> myChildByNameMap;

    public JasmineSuiteStructure(@NotNull String name, @NotNull JSCallExpression enclosingCallExpression, @NotNull JSFunctionExpression specDefinitions, @Nullable JasmineSuiteStructure parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "<init>"));
        }
        if (enclosingCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingCallExpression", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "<init>"));
        }
        if (specDefinitions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specDefinitions", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "<init>"));
        }
        super(name, parent);
        this.mySuiteChildren = Lists.newArrayList();
        this.mySpecChildren = Lists.newArrayList();
        this.myChildByNameMap = Maps.newLinkedHashMap();
        this.myEnclosingCallExpression = enclosingCallExpression;
        this.mySpecDefinitions = specDefinitions;
    }

    @NotNull
    public JSCallExpression getEnclosingCallExpression() {
        JSCallExpression jSCallExpression = this.myEnclosingCallExpression;
        if (jSCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "getEnclosingCallExpression"));
        }
        return jSCallExpression;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = AbstractJasmineElement.getNavigationElement(this.myEnclosingCallExpression);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "getNavigationElement"));
        }
        return psiElement;
    }

    @NotNull
    public JSFunctionExpression getSpecDefinitions() {
        JSFunctionExpression jSFunctionExpression = this.mySpecDefinitions;
        if (jSFunctionExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "getSpecDefinitions"));
        }
        return jSFunctionExpression;
    }

    public void addChild(@NotNull AbstractJasmineElement child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "addChild"));
        }
        if (child instanceof JasmineSuiteStructure) {
            JasmineSuiteStructure suiteStructure = (JasmineSuiteStructure)child;
            this.mySuiteChildren.add(suiteStructure);
        } else if (child instanceof JasmineSpecStructure) {
            JasmineSpecStructure specStructure = (JasmineSpecStructure)child;
            this.mySpecChildren.add(specStructure);
        }
    }

    @Nullable
    public JasmineSuiteStructure getInnerSuiteByName(String suiteName) {
        AbstractJasmineElement child = this.myChildByNameMap.get(suiteName);
        if (child instanceof JasmineSuiteStructure) {
            return (JasmineSuiteStructure)child;
        }
        return null;
    }

    @Nullable
    public JasmineSpecStructure getInnerSpecByName(String specName) {
        AbstractJasmineElement child = this.myChildByNameMap.get(specName);
        return (JasmineSpecStructure)ObjectUtils.tryCast((Object)child, JasmineSpecStructure.class);
    }

    public int getSuiteChildrenCount() {
        return this.mySuiteChildren.size();
    }

    public int getSpecCount() {
        return this.mySpecChildren.size();
    }

    @Nullable
    public JasmineSpecStructure findSpecContainingOffset(int offset) {
        for (JasmineSpecStructure specChild : this.mySpecChildren) {
            TextRange specTextRange = specChild.getEnclosingCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(specTextRange, offset)) continue;
            return specChild;
        }
        for (JasmineSuiteStructure suiteChild : this.mySuiteChildren) {
            JasmineSpecStructure specStructure = suiteChild.findSpecContainingOffset(offset);
            if (specStructure == null) continue;
            return specStructure;
        }
        return null;
    }

    @Nullable
    public JasmineSuiteStructure findLowestSuiteStructureContainingOffset(int offset) {
        for (JasmineSuiteStructure suiteStructure : this.mySuiteChildren) {
            JasmineSuiteStructure inner = suiteStructure.findLowestSuiteStructureContainingOffset(offset);
            if (inner == null) continue;
            return null;
        }
        TextRange suiteTextRange = this.myEnclosingCallExpression.getTextRange();
        if (JsPsiUtils.containsOffsetStrictly(suiteTextRange, offset)) {
            return this;
        }
        return null;
    }

    @Nullable
    JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "findJstdRunElement"));
        }
        for (JasmineSpecStructure specChild : this.mySpecChildren) {
            TextRange callTextRange = specChild.getEnclosingCallExpression().getTextRange();
            if (!callTextRange.contains(textRange)) continue;
            return JstdRunElement.newTestMethodRunElement(this.getName(), specChild.getName());
        }
        for (JasmineSuiteStructure suiteChild : this.mySuiteChildren) {
            JstdRunElement jstdRunElement = suiteChild.findJstdRunElement(textRange);
            if (jstdRunElement == null) continue;
            return jstdRunElement;
        }
        if (this.myEnclosingCallExpression.getTextRange().contains(textRange)) {
            return JstdRunElement.newTestCaseRunElement(this.getName());
        }
        return null;
    }

    @NotNull
    public List<JasmineSuiteStructure> getSuites() {
        List<JasmineSuiteStructure> list = this.mySuiteChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "getSuites"));
        }
        return list;
    }

    @NotNull
    public List<JasmineSpecStructure> getSpecs() {
        List<JasmineSpecStructure> list = this.mySpecChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "getSpecs"));
        }
        return list;
    }

    @Nullable
    public JasmineSuiteStructure findSuite(@NotNull String suiteName) {
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "findSuite"));
        }
        AbstractJasmineElement child = this.myChildByNameMap.get(suiteName);
        if (child instanceof JasmineSuiteStructure) {
            return (JasmineSuiteStructure)child;
        }
        int ind = suiteName.lastIndexOf(32);
        while (ind >= 0) {
            String suffix;
            JasmineSuiteStructure suite;
            JasmineSuiteStructure res;
            String prefix = suiteName.substring(0, ind);
            child = this.myChildByNameMap.get(prefix);
            if (child instanceof JasmineSuiteStructure && (res = (suite = (JasmineSuiteStructure)child).findSuite(suffix = suiteName.substring(ind + 1))) != null) {
                return res;
            }
            ind = suiteName.lastIndexOf(32, ind - 1);
        }
        return null;
    }

    public void fillNameMap() {
        AbstractJasmineElement prevChild;
        Iterator<AbstractJasmineElement> it = this.mySuiteChildren.iterator();
        while (it.hasNext()) {
            JasmineSuiteStructure suiteChild = it.next();
            prevChild = this.myChildByNameMap.get(suiteChild.getName());
            if (prevChild == null) {
                this.myChildByNameMap.put(suiteChild.getName(), suiteChild);
                continue;
            }
            if (!(prevChild instanceof JasmineSuiteStructure)) continue;
            ((JasmineSuiteStructure)prevChild).mergeWith(suiteChild);
            it.remove();
        }
        it = this.mySpecChildren.iterator();
        while (it.hasNext()) {
            JasmineSpecStructure specChild = (JasmineSpecStructure)it.next();
            prevChild = this.myChildByNameMap.get(specChild.getName());
            if (prevChild == null) {
                this.myChildByNameMap.put(specChild.getName(), specChild);
                continue;
            }
            it.remove();
        }
    }

    public void mergeWith(@NotNull JasmineSuiteStructure suiteToMerge) {
        if (suiteToMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteToMerge", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "mergeWith"));
        }
        for (JasmineSuiteStructure childSuiteToMerge : suiteToMerge.getSuites()) {
            AbstractJasmineElement prevChild = this.myChildByNameMap.get(childSuiteToMerge.getName());
            if (prevChild == null) {
                this.mySuiteChildren.add(childSuiteToMerge);
                this.myChildByNameMap.put(childSuiteToMerge.getName(), childSuiteToMerge);
                continue;
            }
            if (!(prevChild instanceof JasmineSuiteStructure)) continue;
            ((JasmineSuiteStructure)prevChild).mergeWith(childSuiteToMerge);
        }
        for (JasmineSpecStructure childSpecToMerge : suiteToMerge.getSpecs()) {
            AbstractJasmineElement suiteChild = this.myChildByNameMap.get(childSpecToMerge.getName());
            if (suiteChild != null) continue;
            this.mySpecChildren.add(childSpecToMerge);
            this.myChildByNameMap.put(childSpecToMerge.getName(), childSpecToMerge);
        }
    }

    @Nullable
    public AbstractJasmineElement findJasmineElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure", "findJasmineElement"));
        }
        if (!this.myEnclosingCallExpression.getTextRange().contains(textRange)) {
            return null;
        }
        for (JasmineSpecStructure specChild : this.mySpecChildren) {
            TextRange callTextRange = specChild.getEnclosingCallExpression().getTextRange();
            if (!callTextRange.contains(textRange)) continue;
            return specChild;
        }
        for (JasmineSuiteStructure suiteChild : this.mySuiteChildren) {
            AbstractJasmineElement result = suiteChild.findJasmineElement(textRange);
            if (result == null) continue;
            return result;
        }
        return this;
    }
}

