/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntLongHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchRecords
implements Serializable {
    public static final BatchRecords EMPTY = new BatchRecords((List<Object[]>)ContainerUtil.emptyList(), new TIntLongHashMap(), -1.0);
    protected final TIntLongHashMap myLines;
    protected final List<Object[]> myRecords;
    protected final double mySize;

    /*
     * WARNING - void declaration
     */
    public BatchRecords(@NotNull List<Object[]> objects, long startLine, double d) {
        void size;
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/remote/dbimport/BatchRecords", "<init>"));
        }
        this(objects, BatchRecords.map(objects, startLine), (double)size);
    }

    public BatchRecords(@NotNull List<Object[]> records, @NotNull TIntLongHashMap map, double size) {
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/remote/dbimport/BatchRecords", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/remote/dbimport/BatchRecords", "<init>"));
        }
        this.myRecords = records;
        this.myLines = map;
        this.mySize = size;
    }

    @NotNull
    public List<Object[]> getRecords() {
        List<Object[]> list = this.myRecords;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/BatchRecords", "getRecords"));
        }
        return list;
    }

    public int getLinesCount() {
        return this.myRecords.size();
    }

    public double getBatchSize() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return ((List)ObjectUtils.assertNotNull(this.myRecords)).isEmpty();
    }

    @NotNull
    public Builder builder() {
        Builder builder = new Builder(this.myLines, this.myRecords);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/BatchRecords", "builder"));
        }
        return builder;
    }

    @NotNull
    public ErrorRecord getErrorRecord(@NotNull Exception e, int idx) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/remote/dbimport/BatchRecords", "getErrorRecord"));
        }
        ErrorRecord.ExceptionRecord exceptionRecord = new ErrorRecord.ExceptionRecord(e, this.getLineNumber(idx));
        if (exceptionRecord == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/BatchRecords", "getErrorRecord"));
        }
        return exceptionRecord;
    }

    @NotNull
    public List<BatchRecords> split(int lines) {
        int batches = this.myRecords.size() / lines + (this.myRecords.size() % lines == 0 ? 0 : 1);
        int currentLineIndex = 0;
        ArrayList records = ContainerUtil.newArrayList();
        for (int i = 0; i < batches; ++i) {
            Builder builder = this.builder();
            int last = Math.min(currentLineIndex + lines, this.myRecords.size());
            for (int j = currentLineIndex; j < last; ++j) {
                builder.record(j);
            }
            double subBatchSize = this.mySize * (double)(last - currentLineIndex) / (double)this.myRecords.size();
            records.add(builder.size(subBatchSize).build());
            currentLineIndex += lines;
        }
        ArrayList arrayList = records;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/BatchRecords", "split"));
        }
        return arrayList;
    }

    protected long getLineNumber(int idx) {
        return this.myLines.get(idx);
    }

    @NotNull
    private static TIntLongHashMap map(@NotNull List<Object[]> objects, long line) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/remote/dbimport/BatchRecords", "map"));
        }
        TIntLongHashMap map = new TIntLongHashMap();
        for (int i = 0; i < objects.size(); ++i) {
            map.put(i, line + (long)i + 1L);
        }
        TIntLongHashMap tIntLongHashMap = map;
        if (tIntLongHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/BatchRecords", "map"));
        }
        return tIntLongHashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        protected final TIntLongHashMap myOldLines;
        protected final List<Object[]> myOldRecords;
        protected final TIntLongHashMap myLines;
        protected final List<Object[]> myRecords;
        protected double mySize;

        protected Builder(@NotNull TIntLongHashMap lines, List<Object[]> records) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/database/remote/dbimport/BatchRecords$Builder", "<init>"));
            }
            this.myOldLines = lines;
            this.myOldRecords = records;
            this.mySize = 0.0;
            this.myLines = new TIntLongHashMap();
            this.myRecords = ContainerUtil.newArrayList();
        }

        @NotNull
        public Builder size(double size) {
            this.mySize += size;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/BatchRecords$Builder", "size"));
            }
            return builder;
        }

        @NotNull
        public Builder record(@NotNull Object[] record, int oldIndex) {
            if (record == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/database/remote/dbimport/BatchRecords$Builder", "record"));
            }
            this.myLines.put(this.myRecords.size(), this.myOldLines.get(oldIndex));
            this.myRecords.add(record);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/BatchRecords$Builder", "record"));
            }
            return builder;
        }

        @NotNull
        public Builder record(int oldIndex) {
            Builder builder = this.record(this.myOldRecords.get(oldIndex), oldIndex);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/BatchRecords$Builder", "record"));
            }
            return builder;
        }

        @NotNull
        public BatchRecords build() {
            BatchRecords batchRecords = new BatchRecords(this.myRecords, this.myLines, this.mySize);
            if (batchRecords == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/BatchRecords$Builder", "build"));
            }
            return batchRecords;
        }
    }
}

