/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.VtlReferenceContributor;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.files.VtlFile;
import org.jetbrains.annotations.NotNull;

public class VtlVariableTypeAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/VtlVariableTypeAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/velocity/inspections/VtlVariableTypeAnnotator", "annotate"));
        }
        if (!VtlReferenceContributor.VTLVARIABLE_COMMENT.accepts((Object)element)) {
            return;
        }
        String text = element.getText();
        String[] nameAndType = VtlFile.findVariableNameAndTypeAndScopeFilePath(text);
        if (nameAndType == null) {
            return;
        }
        VtlImplicitVariable variable = ((VtlFile)element.getContainingFile()).findImplicitVariable(nameAndType[0], nameAndType[2]);
        if (variable == null) {
            return;
        }
        PsiType varType = variable.getPsiType();
        if (varType instanceof PsiPrimitiveType) {
            return;
        }
        String message = varType == null ? null : JavaHighlightUtil.checkPsiTypeUseInContext((PsiType)varType, (PsiElement)element);
        for (PsiReference javaRef : VtlReferenceContributor.getReferencesToJavaTypes(element)) {
            if (javaRef.resolve() != null) continue;
            TextRange range = javaRef.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            holder.createErrorAnnotation(range, message != null ? message : VelocityBundle.message("invalid.java.type", new Object[0]));
        }
    }
}

