/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.MappedByteBufferInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MappedByteBufferOutputStream
extends OutputStream {
    private final MappedByteBufferInputStream parent;

    MappedByteBufferOutputStream(MappedByteBufferInputStream mappedByteBufferInputStream, MappedByteBufferInputStream.FileResizeOp fileResizeOp) throws IOException {
        if (FileChannel.MapMode.READ_ONLY == mappedByteBufferInputStream.getMapMode()) {
            throw new IOException("FileChannel map-mode is read-only");
        }
        this.parent = mappedByteBufferInputStream;
        this.parent.setFileResizeOp(fileResizeOp);
    }

    public MappedByteBufferOutputStream(FileChannel fileChannel, FileChannel.MapMode mapMode, MappedByteBufferInputStream.CacheMode cacheMode, int n, MappedByteBufferInputStream.FileResizeOp fileResizeOp) throws IOException {
        this(new MappedByteBufferInputStream(fileChannel, mapMode, cacheMode, n, fileChannel.size(), 0), fileResizeOp);
    }

    public final synchronized void setSynchronous(boolean bl) {
        this.parent.setSynchronous(bl);
    }

    public final synchronized boolean getSynchronous() {
        return this.parent.getSynchronous();
    }

    public final synchronized void setLength(long l) throws IOException {
        this.parent.setLength(l);
    }

    public final synchronized void notifyLengthChange(long l) throws IOException {
        this.parent.notifyLengthChange(l);
    }

    public final synchronized long length() {
        return this.parent.length();
    }

    public final synchronized long remaining() throws IOException {
        return this.parent.remaining();
    }

    public final synchronized long position() throws IOException {
        return this.parent.position();
    }

    public final synchronized MappedByteBufferInputStream position(long l) throws IOException {
        return this.parent.position(l);
    }

    public final synchronized long skip(long l) throws IOException {
        return this.parent.skip(l);
    }

    @Override
    public final synchronized void flush() throws IOException {
        this.parent.flush(true);
    }

    public final synchronized void flush(boolean bl) throws IOException {
        this.parent.flush(bl);
    }

    @Override
    public final synchronized void close() throws IOException {
        this.parent.close();
    }

    @Override
    public final synchronized void write(int n) throws IOException {
        ByteBuffer byteBuffer;
        int n2;
        this.parent.checkOpen();
        long l = this.parent.remaining();
        if (l < 1L) {
            this.parent.setLength(this.parent.length() + 1L);
        }
        if (0 == (n2 = (byteBuffer = this.parent.currentSlice()).remaining()) && null == (byteBuffer = this.parent.nextSlice())) {
            if (MappedByteBufferInputStream.DEBUG) {
                String string = String.valueOf(this.parent.currentSlice());
                System.err.println(new StringBuilder(11 + String.valueOf(string).length()).append("EOT write: ").append(string).toString());
                this.parent.dbgDump("EOT write:", System.err);
            }
            throw new IOException("EOT");
        }
        byteBuffer.put((byte)(n & 0xFF));
        if (null != byteBuffer) {
            this.parent.syncSlice(byteBuffer);
        }
    }

    @Override
    public final synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.parent.checkOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length || n + n2 > byArray.length || n + n2 < 0) {
            int n4 = byArray.length;
            throw new IndexOutOfBoundsException(new StringBuilder(60).append("offset ").append(n).append(", length ").append(n2).append(", b.length ").append(n4).toString());
        }
        if (0 == n2) {
            return;
        }
        long l = this.parent.remaining();
        if (l < (long)n2) {
            this.parent.setLength(this.parent.length() + (long)n2 - l);
        }
        ByteBuffer byteBuffer = null;
        for (int i = 0; i < n2; i += n3) {
            byteBuffer = this.parent.currentSlice();
            int n5 = byteBuffer.remaining();
            if (0 == n5) {
                byteBuffer = this.parent.nextSlice();
                if (null == byteBuffer) {
                    if (MappedByteBufferInputStream.DEBUG) {
                        n3 = byArray.length;
                        System.err.println(new StringBuilder(71).append("EOT write: offset ").append(n).append(", length ").append(n2).append(", b.length ").append(n3).toString());
                        n3 = i;
                        int n6 = n5;
                        System.err.println(new StringBuilder(65).append("EOT write: written ").append(n3).append(" / ").append(n2).append(", currRem ").append(n6).toString());
                        String string = String.valueOf(this.parent.currentSlice());
                        System.err.println(new StringBuilder(11 + String.valueOf(string).length()).append("EOT write: ").append(string).toString());
                        this.parent.dbgDump("EOT write:", System.err);
                    }
                    throw new InternalError("EOT");
                }
                n5 = byteBuffer.remaining();
            }
            n3 = Math.min(n2 - i, n5);
            byteBuffer.put(byArray, n + i, n3);
        }
        if (null != byteBuffer) {
            this.parent.syncSlice(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void write(ByteBuffer byteBuffer, int n) throws IOException {
        int n2;
        this.parent.checkOpen();
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byteBuffer.remaining()) {
            String string = String.valueOf(byteBuffer);
            throw new IndexOutOfBoundsException(new StringBuilder(22 + String.valueOf(string).length()).append("length ").append(n).append(", b ").append(string).toString());
        }
        if (0 == n) {
            return;
        }
        long l = this.parent.remaining();
        if (l < (long)n) {
            this.parent.setLength(this.parent.length() + (long)n - l);
        }
        ByteBuffer byteBuffer2 = null;
        for (int i = 0; i < n; i += n2) {
            int n3;
            byteBuffer2 = this.parent.currentSlice();
            int n4 = byteBuffer2.remaining();
            if (0 == n4) {
                byteBuffer2 = this.parent.nextSlice();
                if (null == byteBuffer2) {
                    if (MappedByteBufferInputStream.DEBUG) {
                        String string = String.valueOf(byteBuffer);
                        System.err.println(new StringBuilder(33 + String.valueOf(string).length()).append("EOT write: length ").append(n).append(", b ").append(string).toString());
                        int n5 = i;
                        n3 = n4;
                        System.err.println(new StringBuilder(65).append("EOT write: written ").append(n5).append(" / ").append(n).append(", currRem ").append(n3).toString());
                        String string2 = String.valueOf(this.parent.currentSlice());
                        System.err.println(new StringBuilder(11 + String.valueOf(string2).length()).append("EOT write: ").append(string2).toString());
                        this.parent.dbgDump("EOT write:", System.err);
                    }
                    throw new InternalError("EOT");
                }
                n4 = byteBuffer2.remaining();
            }
            n2 = Math.min(n - i, n4);
            if (byteBuffer2.hasArray() && byteBuffer.hasArray()) {
                System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer2.array(), byteBuffer2.arrayOffset() + byteBuffer2.position(), n2);
                byteBuffer.position(byteBuffer.position() + n2);
                byteBuffer2.position(byteBuffer2.position() + n2);
                continue;
            }
            if (n2 == n4) {
                byteBuffer2.put(byteBuffer);
                continue;
            }
            n3 = byteBuffer.limit();
            byteBuffer.limit(n2);
            try {
                byteBuffer2.put(byteBuffer);
                continue;
            }
            finally {
                byteBuffer.limit(n3);
            }
        }
        if (null != byteBuffer2) {
            this.parent.syncSlice(byteBuffer2);
        }
    }

    public final synchronized void write(MappedByteBufferInputStream mappedByteBufferInputStream, long l) throws IOException {
        int n;
        this.parent.checkOpen();
        if (mappedByteBufferInputStream == null) {
            throw new NullPointerException();
        }
        if (l < 0L || l > mappedByteBufferInputStream.remaining()) {
            String string = String.valueOf(mappedByteBufferInputStream);
            throw new IndexOutOfBoundsException(new StringBuilder(31 + String.valueOf(string).length()).append("length ").append(l).append(", b ").append(string).toString());
        }
        if (0L == l) {
            return;
        }
        long l2 = this.parent.remaining();
        if (l2 < l) {
            this.parent.setLength(this.parent.length() + l - l2);
        }
        ByteBuffer byteBuffer = null;
        for (long i = 0L; i < l; i += (long)n) {
            byteBuffer = this.parent.currentSlice();
            int n2 = byteBuffer.remaining();
            if (0 == n2) {
                byteBuffer = this.parent.nextSlice();
                if (null == byteBuffer) {
                    if (MappedByteBufferInputStream.DEBUG) {
                        String string = String.valueOf(mappedByteBufferInputStream);
                        System.err.println(new StringBuilder(42 + String.valueOf(string).length()).append("EOT write: length ").append(l).append(", b ").append(string).toString());
                        long l3 = i;
                        int n3 = n2;
                        System.err.println(new StringBuilder(83).append("EOT write: written ").append(l3).append(" / ").append(l).append(", currRem ").append(n3).toString());
                        String string2 = String.valueOf(this.parent.currentSlice());
                        System.err.println(new StringBuilder(11 + String.valueOf(string2).length()).append("EOT write: ").append(string2).toString());
                        this.parent.dbgDump("EOT write:", System.err);
                    }
                    throw new InternalError("EOT");
                }
                n2 = byteBuffer.remaining();
            }
            if (0 <= (n = mappedByteBufferInputStream.read(byteBuffer, (int)Math.min(l - i, (long)n2)))) continue;
            throw new InternalError("Unexpected InputStream EOT");
        }
        if (null != byteBuffer) {
            this.parent.syncSlice(byteBuffer);
        }
    }
}

