/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;

public class WrongCallDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("WrongCall", "Using wrong draw/layout method", "Custom views typically need to call `measure()` on their children, not `onMeasure`. Ditto for onDraw, onLayout, etc.", Category.CORRECTNESS, 6, Severity.FATAL, new Implementation(WrongCallDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("onDraw", "onMeasure", "onLayout");
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression node, PsiMethod calledMethod) {
        String callName;
        PsiElement operand = node.getMethodExpression().getQualifier();
        if (!(operand instanceof PsiSuperExpression)) {
            WrongCallDetector.report(context, node, calledMethod);
            return;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)node, PsiMethod.class, (boolean)true);
        if (method != null && (callName = node.getMethodExpression().getReferenceName()) != null && !callName.equals(method.getName())) {
            WrongCallDetector.report(context, node, calledMethod);
        }
    }

    private static void report(JavaContext context, PsiMethodCallExpression node, PsiMethod method) {
        if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
            return;
        }
        String name = method.getName();
        String suggestion = Character.toLowerCase(name.charAt(2)) + name.substring(3);
        String message = String.format("Suspicious method call; should probably call \"`%1$s`\" rather than \"`%2$s`\"", suggestion, name);
        context.report(ISSUE, (PsiElement)node, context.getNameLocation((PsiElement)node), message);
    }

    public static String getOldValue(String errorMessage, TextFormat format) {
        errorMessage = format.toText(errorMessage);
        return LintUtils.findSubstring(errorMessage, "than \"", "\"");
    }

    public static String getNewValue(String errorMessage, TextFormat format) {
        errorMessage = format.toText(errorMessage);
        return LintUtils.findSubstring(errorMessage, "call \"", "\"");
    }
}

