/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringLibraryUtil {
    public static boolean hasSpringLibrary(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/SpringLibraryUtil", "hasSpringLibrary"));
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/SpringLibraryUtil", "lambda$hasSpringLibrary$0"));
            }
            DumbService dumbService = DumbService.getInstance((Project)project);
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{dumbService.getModificationTracker()});
            }
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass(SpringVersion.ANY.getDetectionClassFqn(), ProjectScope.getLibrariesScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    public static boolean hasSpringLibrary(@Nullable Module module) {
        return SpringLibraryUtil.isAtLeastVersion(module, SpringVersion.ANY);
    }

    public static boolean isAtLeastVersion(@Nullable Module module, SpringVersion version) {
        if (module == null) {
            return false;
        }
        if (!SpringLibraryUtil.hasSpringLibrary(module.getProject())) {
            return false;
        }
        SpringVersion cached = SpringLibraryUtil.getCachedSpringVersion(module);
        return cached != null && cached.isAtLeast(version);
    }

    @Nullable
    private static SpringVersion getCachedSpringVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/SpringLibraryUtil", "getCachedSpringVersion"));
        }
        Project project = module.getProject();
        return (SpringVersion)((Object)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/SpringLibraryUtil", "lambda$getCachedSpringVersion$1"));
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            SpringVersion detected = null;
            for (SpringVersion version : (SpringVersion[])ArrayUtil.reverseArray((Object[])SpringVersion.values())) {
                PsiClass psiClass = javaPsiFacade.findClass(version.getDetectionClassFqn(), scope);
                if (psiClass == null) continue;
                detected = version;
                break;
            }
            return CachedValueProvider.Result.create(detected, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }));
    }

    public static enum SpringVersion {
        ANY("1.0", "org.springframework.beans.factory.BeanFactory"),
        V_2_5("2.5", "org.springframework.core.PriorityOrdered"),
        V_4_2("4.2", "org.springframework.beans.AbstractNestablePropertyAccessor"),
        V_4_3("4.3", "org.springframework.core.MethodClassKey"),
        V_5_0("5.0", "org.springframework.core.ReactiveAdapter");

        private final String myVersion;
        private final String myDetectionClassFqn;

        private SpringVersion(String version, String detectionClassFqn) {
            this.myVersion = version;
            this.myDetectionClassFqn = detectionClassFqn;
        }

        boolean isAtLeast(SpringVersion reference) {
            if (reference == ANY) {
                return true;
            }
            return StringUtil.compareVersionNumbers((String)this.getVersion(), (String)reference.getVersion()) >= 0;
        }

        String getVersion() {
            return this.myVersion;
        }

        String getDetectionClassFqn() {
            return this.myDetectionClassFqn;
        }
    }
}

