/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import org.jetbrains.annotations.NotNull;

public abstract class SpringBeanPointerResolveInspection
extends BaseJavaLocalInspectionTool {
    protected static boolean isPlainJavaFileInSpringModule(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/model/highlighting/jam/SpringBeanPointerResolveInspection", "isPlainJavaFileInSpringModule"));
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiElement.getContainingFile())) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        return SpringCommonUtils.hasSpringFacet(module);
    }

    public static void checkBeanPointerResolve(ProblemsHolder holder, JamStringAttributeElement<SpringBeanPointer> element, @NotNull String beanType) {
        PsiAnnotationMemberValue memberValue;
        if (beanType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanType", "com/intellij/spring/model/highlighting/jam/SpringBeanPointerResolveInspection", "checkBeanPointerResolve"));
        }
        String beanName = element.getStringValue();
        if (beanName != null && (memberValue = element.getPsiElement()) != null) {
            PsiClass psiClass;
            SpringBeanPointer value = (SpringBeanPointer)element.getValue();
            if (value == null) {
                holder.registerProblem((PsiElement)memberValue, SpringApiBundle.message("model.bean.error.message", beanName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            } else if (StringUtil.isNotEmpty((String)beanType) && (psiClass = value.getBeanClass()) != null && !InheritanceUtil.isInheritor((PsiClass)psiClass, (String)beanType)) {
                holder.registerProblem((PsiElement)memberValue, SpringApiBundle.message("bean.must.be.of.type", beanType), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }
}

