/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.propertySources;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.jam.converters.PropertiesFileConverter;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringTestPropertySource
implements SpringPropertySource {
    protected static SemKey<SpringTestPropertySource> SPRING_TEST_PROPERTY_SOURCE_JAM_KEY = PROPERTY_SOURCE_JAM_KEY.subKey("SpringTestPropertySource", new SemKey[0]);
    private static final JamStringAttributeMeta.Collection<Set<PropertiesFile>> VALUE_ATTR_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new PropertiesFileConverter());
    private static final JamStringAttributeMeta.Collection<Set<PropertiesFile>> LOCATIONS_ATTR_META = JamAttributeMeta.collectionString((String)"locations", (JamConverter)new PropertiesFileConverter());
    static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("org.springframework.test.context.TestPropertySource");
    public static final JamClassMeta<SpringTestPropertySource> META = new JamClassMeta(null, SpringTestPropertySource.class, SPRING_TEST_PROPERTY_SOURCE_JAM_KEY);
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final PsiClass myPsiClass;

    public SpringTestPropertySource(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/jam/testContexts/propertySources/SpringTestPropertySource", "<init>"));
        }
        this.myPsiClass = psiClass;
        this.myPsiAnnotation = ANNO_META.getAnnotationRef((PsiModifierListOwner)psiClass);
    }

    public SpringTestPropertySource(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/model/jam/testContexts/propertySources/SpringTestPropertySource", "<init>"));
        }
        this.myPsiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class, (boolean)true);
        this.myPsiAnnotation = PsiElementRef.real((PsiElement)annotation);
    }

    @Override
    @JamPsiConnector
    @NotNull
    public PsiClass getPsiElement() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/propertySources/SpringTestPropertySource", "getPsiElement"));
        }
        return psiClass;
    }

    @Override
    public boolean isPsiValid() {
        return this.myPsiClass.isValid();
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return ANNO_META.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    @Override
    public Set<PropertiesFile> getPropertiesFiles() {
        LinkedHashSet propertiesFiles = ContainerUtil.newLinkedHashSet();
        if (this.getValueAttr().isEmpty() && this.getLocationsAttr().isEmpty()) {
            PropertiesFile propertiesFile = this.getDefaultPropertiesFile();
            if (propertiesFile != null) {
                return Collections.singleton(propertiesFile);
            }
        } else {
            this.addPropertiesFiles(propertiesFiles, this.getValueAttr());
            this.addPropertiesFiles(propertiesFiles, this.getLocationsAttr());
        }
        return propertiesFiles;
    }

    @NotNull
    protected List<JamStringAttributeElement<Set<PropertiesFile>>> getLocationsAttr() {
        List list = LOCATIONS_ATTR_META.getJam(this.myPsiAnnotation);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/propertySources/SpringTestPropertySource", "getLocationsAttr"));
        }
        return list;
    }

    @NotNull
    protected List<JamStringAttributeElement<Set<PropertiesFile>>> getValueAttr() {
        List list = VALUE_ATTR_META.getJam(this.myPsiAnnotation);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/propertySources/SpringTestPropertySource", "getValueAttr"));
        }
        return list;
    }

    protected void addPropertiesFiles(@NotNull Set<PropertiesFile> propertiesFiles, @NotNull List<JamStringAttributeElement<Set<PropertiesFile>>> attributeValues) {
        if (propertiesFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFiles", "com/intellij/spring/model/jam/testContexts/propertySources/SpringTestPropertySource", "addPropertiesFiles"));
        }
        if (attributeValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValues", "com/intellij/spring/model/jam/testContexts/propertySources/SpringTestPropertySource", "addPropertiesFiles"));
        }
        for (JamStringAttributeElement<Set<PropertiesFile>> attributeElement : attributeValues) {
            Set value = (Set)attributeElement.getValue();
            if (value == null) continue;
            propertiesFiles.addAll(value);
        }
    }

    @Nullable
    private PropertiesFile getDefaultPropertiesFile() {
        String propertiesFileName = this.getDefaultPropertiesFileName();
        PsiDirectory containingDirectory = this.getPsiElement().getContainingFile().getContainingDirectory();
        if (containingDirectory != null) {
            PsiFile file = containingDirectory.findFile(propertiesFileName);
            if (file instanceof PropertiesFile) {
                return (PropertiesFile)file;
            }
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
            if (psiPackage != null) {
                for (PsiDirectory psiDirectory : psiPackage.getDirectories()) {
                    file = psiDirectory.findFile(propertiesFileName);
                    if (!(file instanceof PropertiesFile)) continue;
                    return (PropertiesFile)file;
                }
            }
        }
        return null;
    }

    private String getDefaultPropertiesFileName() {
        return this.getPsiElement().getName() + ".properties";
    }

    static {
        META.addAnnotation(ANNO_META);
        ANNO_META.addAttribute(VALUE_ATTR_META);
        ANNO_META.addAttribute(LOCATIONS_ATTR_META);
    }
}

