/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.ws.inspections.SpringWebServicesContextParamsProvider;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebServicesUtil {
    private static final Key<CachedValue<Set<XmlFile>>> WSDL_FILES_KEY = Key.create((String)"wsdl files");

    public static boolean isMessageDispatcherServletDefined(Collection<WebFacet> webFacets) {
        return SpringWebServicesUtil.getMessageDispatcherServlet(webFacets) != null;
    }

    @Nullable
    public static Servlet getMessageDispatcherServlet(@NotNull Collection<WebFacet> webFacets) {
        if (webFacets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacets", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getMessageDispatcherServlet"));
        }
        for (WebFacet webFacet : webFacets) {
            WebApp webApp = webFacet.getRoot();
            if (webApp == null) continue;
            for (Servlet servlet : webApp.getServlets()) {
                if (!SpringWebServicesUtil.isMessageDispatcherServlet(servlet)) continue;
                return servlet;
            }
        }
        return null;
    }

    public static boolean isMessageDispatcherServlet(@NotNull Servlet servlet) {
        if (servlet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servlet", "com/intellij/spring/ws/util/SpringWebServicesUtil", "isMessageDispatcherServlet"));
        }
        if ("org.springframework.ws.transport.http.MessageDispatcherServlet".equals(servlet.getServletClass().getStringValue())) {
            return true;
        }
        PsiClass psiClass = (PsiClass)servlet.getServletClass().getValue();
        return psiClass != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.ws.transport.http.MessageDispatcherServlet");
    }

    @Nullable
    public static String getMessageDispatcherServletName(Collection<WebFacet> webFacets) {
        Servlet dispatcherServlet = SpringWebServicesUtil.getMessageDispatcherServlet(webFacets);
        return dispatcherServlet == null ? null : dispatcherServlet.getServletName().getStringValue();
    }

    @NotNull
    public static Set<XmlFile> getMessageDispatcherServletContexts(@NotNull Servlet servlet) {
        String servletName;
        Module module;
        if (servlet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servlet", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getMessageDispatcherServletContexts"));
        }
        HashSet appFiles = new HashSet();
        XmlTag tag = servlet.getXmlTag();
        if (tag != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag)) != null && !StringUtil.isEmptyOrSpaces((String)(servletName = servlet.getServletName().getStringValue()))) {
            String relativePath = SpringWebServicesUtil.getApplicationContextRelativePath(servletName);
            for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
                PsiFile psiFile;
                WebDirectoryElement element = WebDirectoryUtil.getWebDirectoryUtil((Project)webFacet.getModule().getProject()).findWebDirectoryElementByPath(relativePath, webFacet);
                if (element == null || !((psiFile = element.getOriginalFile()) instanceof XmlFile) || !SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) continue;
                appFiles.add((XmlFile)psiFile);
            }
        }
        HashSet hashSet = appFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getMessageDispatcherServletContexts"));
        }
        return hashSet;
    }

    @NotNull
    public static String getApplicationContextRelativePath(@NotNull String servletName) {
        if (servletName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servletName", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getApplicationContextRelativePath"));
        }
        String string = "WEB-INF/" + SpringWebServicesUtil.getApplicationContextFileName(servletName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getApplicationContextRelativePath"));
        }
        return string;
    }

    @NotNull
    public static String getApplicationContextFileName(@NotNull String servletName) {
        if (servletName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servletName", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getApplicationContextFileName"));
        }
        String string = servletName + "-servlet.xml";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getApplicationContextFileName"));
        }
        return string;
    }

    public static boolean isSpringWebServiceBeansDefined(DomFileElement<Beans> fileElement) {
        LocalXmlModel springModel;
        Module module = fileElement.getModule();
        if (module != null && (springModel = SpringManager.getInstance((Project)module.getProject()).getLocalSpringModel(fileElement.getFile())) != null) {
            return SpringWebServicesUtil.isWsdlDefinitionDefined(fileElement, (CommonSpringModel)springModel) || SpringWebServicesUtil.isEndpointsDefined(fileElement, (CommonSpringModel)springModel);
        }
        return false;
    }

    private static boolean isWsdlDefinitionDefined(DomFileElement<Beans> fileElement, @NotNull CommonSpringModel springModel) {
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/ws/util/SpringWebServicesUtil", "isWsdlDefinitionDefined"));
        }
        PsiClass psiClass = DomJavaUtil.findClass((String)"org.springframework.ws.wsdl.WsdlDefinition", fileElement);
        return psiClass != null && SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (PsiClass)psiClass);
    }

    private static boolean isEndpointsDefined(DomFileElement<Beans> fileElement, @NotNull CommonSpringModel springModel) {
        if (springModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springModel", "com/intellij/spring/ws/util/SpringWebServicesUtil", "isEndpointsDefined"));
        }
        PsiClass psiClass = DomJavaUtil.findClass((String)"org.springframework.ws.server.endpoint.PayloadEndpoint", fileElement);
        return SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (PsiClass)psiClass);
    }

    @Nullable
    public static LookupElement createLookupElementFor(@NotNull String key, @Nullable PsiFile target) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/ws/util/SpringWebServicesUtil", "createLookupElementFor"));
        }
        return LookupElementBuilder.create((String)key).withIcon(target == null ? null : target.getIcon(0)).withTypeText(target == null ? "" : target.getName());
    }

    public static boolean isEndpointMappingProperty(GenericDomValue value) {
        return SpringPropertyUtils.isSpecificProperty((GenericDomValue)value, (String)"mappings", (String[])new String[]{"org.springframework.ws.server.endpoint.mapping.AbstractMapBasedEndpointMapping"});
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddressingInputActions(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingInputActions"));
        }
        Map<String, PsiElement> map = SpringWebServicesUtil.collectWebServiceAddressingActions(module, "input");
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingInputActions"));
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddressingOutputActions(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingOutputActions"));
        }
        Map<String, PsiElement> map = SpringWebServicesUtil.collectWebServiceAddressingActions(module, "output");
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingOutputActions"));
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddressingActions(@NotNull Module module, @NotNull String tagLocalname) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingActions"));
        }
        if (tagLocalname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagLocalname", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingActions"));
        }
        Map<String, PsiElement> map = SpringWebServicesUtil.collectWebServiceAddressingElements(module, tagLocalname, "http://schemas.xmlsoap.org/wsdl/", "Action", "http://www.w3.org/2006/05/addressing/wsdl");
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingActions"));
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddresses(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddresses"));
        }
        Map<String, PsiElement> map = SpringWebServicesUtil.collectWebServiceAddressingElements(module, "address", "http://schemas.xmlsoap.org/wsdl/soap/", "location", null);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddresses"));
        }
        return map;
    }

    @NotNull
    public static Map<String, PsiElement> collectWebServiceAddressingElements(@NotNull Module module, final @NotNull String tagLocalName, final @NotNull String tagNamespace, final @NotNull String attrName, final @Nullable String attrNamespace) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingElements"));
        }
        if (tagLocalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagLocalName", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingElements"));
        }
        if (tagNamespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagNamespace", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingElements"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingElements"));
        }
        HashMap actions = new HashMap();
        for (XmlFile xmlFile : SpringWebServicesUtil.getWsdlFiles(module)) {
            xmlFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor((Map)actions){
                final /* synthetic */ Map val$actions;
                {
                    this.val$actions = map;
                }

                public void visitXmlTag(XmlTag tag) {
                    if (tag.getLocalName().equals(tagLocalName) && tag.getNamespace().equals(tagNamespace)) {
                        String inputAction;
                        XmlAttribute attribute;
                        XmlAttribute xmlAttribute = attribute = attrNamespace == null ? tag.getAttribute(attrName) : tag.getAttribute(attrName, attrNamespace);
                        if (attribute != null && !StringUtil.isEmptyOrSpaces((String)(inputAction = attribute.getValue()))) {
                            this.val$actions.put(inputAction, attribute);
                        }
                    } else {
                        super.visitXmlTag(tag);
                    }
                }
            });
        }
        HashMap hashMap = actions;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "collectWebServiceAddressingElements"));
        }
        return hashMap;
    }

    @NotNull
    public static Set<XmlFile> getWsdlFiles(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getWsdlFiles"));
        }
        Project project = module.getProject();
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        Set files = (Set)manager.getCachedValue((UserDataHolder)module, WSDL_FILES_KEY, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServicesUtil", "lambda$getWsdlFiles$0"));
            }
            return SpringWebServicesUtil.findWsdlFiles(module);
        }, false);
        Set set = files == null ? Collections.emptySet() : files;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getWsdlFiles"));
        }
        return set;
    }

    @NotNull
    private static CachedValueProvider.Result<Set<XmlFile>> findWsdlFiles(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServicesUtil", "findWsdlFiles"));
        }
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
        dependencies.add(VirtualFileManager.getInstance());
        HashSet wsdlFiles = new HashSet();
        for (VirtualFile file : FilenameIndex.getAllFilesByExt((Project)module.getProject(), (String)"wsdl", (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module))) {
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
            if (!(psiFile instanceof XmlFile)) continue;
            wsdlFiles.add((XmlFile)psiFile);
        }
        CachedValueProvider.Result result = new CachedValueProvider.Result((Object)wsdlFiles, dependencies.toArray());
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServicesUtil", "findWsdlFiles"));
        }
        return result;
    }

    @Nullable
    public static ParamValue getContextConfigurationParam(@NotNull Servlet servlet) {
        if (servlet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servlet", "com/intellij/spring/ws/util/SpringWebServicesUtil", "getContextConfigurationParam"));
        }
        WebApp app = (WebApp)servlet.getParentOfType(WebApp.class, false);
        if (app != null) {
            for (ParamValue param : app.getContextParams()) {
                if (!SpringWebServicesContextParamsProvider.CONTEXT_CONFIGURATION_PARAM_NAME.equals(param.getParamName().getValue())) continue;
                return param;
            }
        }
        return null;
    }
}

