/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.utils;

import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.manipulators.AbstractPersistenceAction;
import com.intellij.persistence.model.manipulators.AbstractPersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceManipulator;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.persistence.integration.utils.IntegrationUtil;
import icons.SpringPersistenceIntegrationIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringBeansManipulator
extends AbstractPersistenceManipulator<Beans>
implements PersistenceManipulator<Beans> {
    private String myName;

    public SpringBeansManipulator(Beans target) {
        super((Object)target);
    }

    public List<PersistenceAction> getCreateActions() {
        return Arrays.asList(new AbstractPersistenceAction<SpringBeansManipulator>(this, "Session Factory Bean", "Session Factory Bean", SpringPersistenceIntegrationIcons.SpringSessionFactory){
            private PersistenceFacet myFacet;

            public int getGroupId() {
                return 10;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                this.myFacet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
                this.getPresentation().setEnabled(this.myFacet != null);
            }

            public boolean preInvoke(UserResponse response) {
                SpringBeansManipulator.this.myName = this.myFacet == null ? null : response.getPersistenceUnitName(this.myFacet);
                return StringUtil.isNotEmpty((String)SpringBeansManipulator.this.myName);
            }

            public void addAffectedElements(@NotNull Collection<PsiElement> affectedElements) {
                if (affectedElements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedElements", "com/intellij/spring/persistence/integration/utils/SpringBeansManipulator$1", "addAffectedElements"));
                }
                affectedElements.add(this.getTargetElement());
            }

            protected PsiElement getTargetElement() {
                return ((Beans)((SpringBeansManipulator)this.getManipulator()).getManipulatorTarget()).getXmlElement();
            }

            public void invokeAction(@NotNull Collection<PsiElement> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/persistence/integration/utils/SpringBeansManipulator$1", "invokeAction"));
                }
                result.add(SpringBeansManipulator.this.createSessionFactory(SpringBeansManipulator.this.myName, this.myFacet).getIdentifyingPsiElement());
            }
        });
    }

    public PersistencePackage createSessionFactory(String unitName, PersistenceFacet facet) {
        Beans beans = (Beans)this.getManipulatorTarget();
        SpringBean bean = beans.addBean();
        bean.getId().setValue((Object)unitName);
        HibernateVersion version = HibernateUtil.getHibernateVersion((Module)facet.getModule());
        if (version == HibernateVersion.Hibernate_4_X) {
            bean.getClazz().setStringValue("org.springframework.orm.hibernate4.LocalSessionFactoryBean");
        } else if (version == HibernateVersion.Hibernate_3_X) {
            bean.getClazz().setStringValue("org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean");
        }
        assert (facet instanceof HibernateFacet);
        return IntegrationUtil.getPersistencePackage(BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean), facet, true);
    }
}

