/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.application.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.application.facet.JavaeeApplicationFacetConfiguration;
import com.intellij.javaee.application.facet.JavaeeApplicationFacetType;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetCommonPart;
import com.intellij.javaee.facet.JavaeeFacetEx;
import com.intellij.javaee.facet.JavaeeFacetListener;
import com.intellij.javaee.model.xml.application.JavaeeApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeApplicationFacetImpl
extends JavaeeApplicationFacet
implements JavaeeFacetEx {
    private final JavaeeFacetCommonPart myCommonPart;

    public JavaeeApplicationFacetImpl(@NotNull JavaeeApplicationFacetType facetType, @NotNull Module module, String name, @NotNull JavaeeApplicationFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/javaee/application/facet/JavaeeApplicationFacetImpl", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/application/facet/JavaeeApplicationFacetImpl", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javaee/application/facet/JavaeeApplicationFacetImpl", "<init>"));
        }
        super((FacetType)facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        this.myCommonPart = new JavaeeFacetCommonPart((JavaeeFacet)this, (ConfigFileMetaDataProvider)facetType.getDescriptorsMetaDataProvider(), configuration.getDescriptorsConfiguration());
        Disposer.register((Disposable)this, (Disposable)this.myCommonPart);
    }

    @Override
    public void onFacetChanged() {
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myCommonPart.getDescriptorsContainer();
    }

    @Override
    public JavaeeFacetCommonPart getCommonPart() {
        return this.myCommonPart;
    }

    public ModificationTracker getModificationTracker() {
        return this.myCommonPart.getModificationTracker();
    }

    public void addFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.addListener(listener);
    }

    public void removeFacetListener(JavaeeFacetListener listener) {
        this.myCommonPart.removeListener(listener);
    }

    @Nullable
    public JavaeeApplication getRoot() {
        ConfigFile deploymentDescriptor = this.getApplicationDescriptor();
        if (deploymentDescriptor == null) {
            return null;
        }
        XmlFile xmlFile = deploymentDescriptor.getXmlFile();
        return (JavaeeApplication)JamCommonUtil.getRootElement((PsiFile)xmlFile, JavaeeApplication.class, (Module)this.getModule());
    }

    @Nullable
    public ConfigFile getApplicationDescriptor() {
        return this.getDescriptorsContainer().getConfigFile(DeploymentDescriptorsConstants.APPLICATION_XML_META_DATA);
    }

    @NotNull
    public Collection<VirtualFile> getFacetRoots() {
        Collection<VirtualFile> collection = this.myCommonPart.getDescriptors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/application/facet/JavaeeApplicationFacetImpl", "getFacetRoots"));
        }
        return collection;
    }

    public void initFacet() {
        this.myCommonPart.initFacet();
    }
}

