/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb;

import com.intellij.facet.FacetTypeId;
import com.intellij.j2ee.JavaeeCachesUtil;
import com.intellij.jam.JamService;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.NewEjbRoleHolder;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.ejb.role.EjbClassRoleImpl;
import com.intellij.javaee.ejb.role.EjbMethodRole;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.annotations.ejb.EnvironmentGroupImpl;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.javaee.model.common.JavaeeReference;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.xml.ejb.Query;
import com.intellij.javaee.model.xml.impl.EjbXmlImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OldEjbRolesUtil {
    private static final JavaeeCachesUtil.CachedValueProviderProvider<Map<PsiMember, JavaeeReference[]>, PsiElement> INJECTED_REFERENCE_PROVIDER_PROVIDER = new JavaeeCachesUtil.CachedValueProviderProvider<Map<PsiMember, JavaeeReference[]>, PsiElement>(){

        @Override
        public CachedValueProvider<Map<PsiMember, JavaeeReference[]>> createProvider(PsiElement psiElement) {
            return () -> {
                EnvironmentGroup environment;
                PsiClass containingClass = (PsiClass)psiElement;
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(containingClass);
                if (classRoles.length == 0) {
                    environment = (EnvironmentGroup)JamService.getJamService((Project)containingClass.getProject()).getJamElement(EnvironmentGroupImpl.JAVAEE_ENVIRONMENT_KEY, (PsiElement)containingClass);
                    if (environment == null) {
                        return new CachedValueProvider.Result(Collections.emptyMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                } else {
                    environment = null;
                }
                THashMap map = new THashMap();
                HashSet<Object> dependencyItemsList = new HashSet<Object>();
                Processor processor = reference -> {
                    for (GenericValue genericValue : reference.getTargetMembers()) {
                        PsiMember key = (PsiMember)genericValue.getValue();
                        if (key == null) continue;
                        Set set = (Set)map.get((Object)key);
                        if (set == null) {
                            set = new THashSet();
                            map.put((Object)key, (Object)set);
                        }
                        set.add(reference);
                    }
                    return true;
                };
                if (environment != null) {
                    ContainerUtil.process((List)environment.getEjbReferences(), (Processor)processor);
                    ContainerUtil.process((List)environment.getResources(), (Processor)processor);
                }
                for (EjbClassRole classRole : classRoles) {
                    Interceptor environmentGroup;
                    if (classRole.getType() == EjbClassRoleEnum.EJB_CLASS_ROLE_INTERCEPTOR_CLASS) {
                        environmentGroup = classRole.getInterceptor();
                    } else {
                        if (classRole.getType() != EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS) continue;
                        environmentGroup = classRole.getEnterpriseBean();
                    }
                    assert (environmentGroup != null);
                    ModificationTracker ejbFacetTracker = classRole.getFacet().getModificationTracker();
                    dependencyItemsList.add(ejbFacetTracker);
                    ContainerUtil.process((List)environmentGroup.getEjbReferences(), (Processor)processor);
                    ContainerUtil.process((List)environmentGroup.getResources(), (Processor)processor);
                }
                THashMap result = new THashMap();
                for (PsiMember psiMember : map.keySet()) {
                    Collection references = (Collection)map.get((Object)psiMember);
                    result.put((Object)psiMember, (Object)references.toArray(new JavaeeReference[references.size()]));
                }
                dependencyItemsList.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                Object[] dependencyItems = dependencyItemsList.toArray();
                return new CachedValueProvider.Result((Object)result, dependencyItems);
            };
        }
    };
    private static final JavaeeCachesUtil.CachedValueProviderProvider<EjbMethodRole[], PsiElement> METHOD_ROLE_PROVIDER_PROVIDER = new JavaeeCachesUtil.CachedValueProviderProvider<EjbMethodRole[], PsiElement>(){

        @Override
        public CachedValueProvider<EjbMethodRole[]> createProvider(PsiElement psiElement) {
            return () -> {
                PsiMethod method = (PsiMethod)psiElement;
                PsiClass containingClass = method.getContainingClass();
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(containingClass);
                if (classRoles.length == 0) {
                    return new CachedValueProvider.Result((Object)EjbMethodRole.EMPTY_ARRAY, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                ArrayList<EjbMethodRole> rolesList = new ArrayList<EjbMethodRole>(classRoles.length);
                THashSet dependencyItemsList = new THashSet();
                for (EjbClassRole classRole : classRoles) {
                    EjbMethodRole methodRole = classRole.getMethodRole(method);
                    if (methodRole != null) {
                        rolesList.add(methodRole);
                    }
                    EnterpriseBean ejb = classRole.getEnterpriseBean();
                    Interceptor interceptor = classRole.getInterceptor();
                    assert (ejb != null || interceptor != null);
                    EjbFacet ejbFacet = classRole.getFacet();
                    dependencyItemsList.add(ejbFacet.getModificationTracker());
                }
                dependencyItemsList.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                EjbMethodRole[] roles = rolesList.size() == 0 ? EjbMethodRole.EMPTY_ARRAY : rolesList.toArray(new EjbMethodRole[rolesList.size()]);
                Object[] dependencyItems = dependencyItemsList.toArray();
                return new CachedValueProvider.Result((Object)roles, dependencyItems);
            };
        }
    };
    private static final JavaeeCachesUtil.CachedValueProviderProvider<Map<PsiMethod, Query[]>, PsiElement> QUERY_PROVIDER_PROVIDER = new JavaeeCachesUtil.CachedValueProviderProvider<Map<PsiMethod, Query[]>, PsiElement>(){

        @Override
        public CachedValueProvider<Map<PsiMethod, Query[]>> createProvider(PsiElement psiElement) {
            return () -> {
                PsiClass containingClass = (PsiClass)psiElement;
                EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(containingClass);
                if (classRoles.length == 0) {
                    return new CachedValueProvider.Result(Collections.emptyMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                THashMap map = new THashMap();
                HashSet<Object> dependencyItemsList = new HashSet<Object>();
                for (EjbClassRole classRole : classRoles) {
                    com.intellij.javaee.model.xml.ejb.EntityBean entity;
                    if (!EjbUtil.isCMP(classRole.getEnterpriseBean(), CmpVersion.CmpVersion_2_X) || (entity = (com.intellij.javaee.model.xml.ejb.EntityBean)ModelMergerUtil.getImplementation((Object)classRole.getEnterpriseBean(), com.intellij.javaee.model.xml.ejb.EntityBean.class)) == null) continue;
                    dependencyItemsList.add(entity.getIdentifyingPsiElement().getContainingFile());
                    for (Query query : entity.getQueries()) {
                        for (PsiMethod psiMethod : EjbXmlImplUtil.findMethods((EntityBean)entity, query.getQueryMethod())) {
                            Set queries = (Set)map.get((Object)psiMethod);
                            if (queries == null) {
                                queries = new THashSet();
                                map.put((Object)psiMethod, (Object)queries);
                            }
                            queries.add(query);
                        }
                    }
                }
                dependencyItemsList.add(containingClass);
                THashMap result = new THashMap();
                for (PsiMethod psiMember : map.keySet()) {
                    Collection queries = (Collection)map.get((Object)psiMember);
                    result.put((Object)psiMember, (Object)queries.toArray(new Query[queries.size()]));
                }
                Object[] dependencyItems = dependencyItemsList.toArray();
                return new CachedValueProvider.Result((Object)result, dependencyItems);
            };
        }
    };
    public static Query[] EMPTY_QUERY_ARRAY = new Query[0];

    private OldEjbRolesUtil() {
    }

    @Deprecated
    @Nullable
    public static EjbMethodRole getEjbRole(PsiMethod method) {
        EjbMethodRole[] methodRoles = OldEjbRolesUtil.getEjbRoles(method);
        if (methodRoles.length == 0) {
            return null;
        }
        return methodRoles[0];
    }

    @Deprecated
    @Nullable
    public static EjbClassRole getEjbRole(PsiClass psiClass) {
        EjbClassRole[] classRoles = OldEjbRolesUtil.getEjbRoles(psiClass);
        if (classRoles.length == 0) {
            return null;
        }
        return classRoles[0];
    }

    @NotNull
    public static EjbMethodRole[] getEjbRoles(PsiMethod method) {
        EjbMethodRole[] methodRoles = JavaeeCachesUtil.getJavaeeValue((PsiElement)method, METHOD_ROLE_PROVIDER_PROVIDER, (FacetTypeId<? extends JavaeeFacet>)EjbFacet.ID);
        EjbMethodRole[] ejbMethodRoleArray = methodRoles != null ? methodRoles : EjbMethodRole.EMPTY_ARRAY;
        if (ejbMethodRoleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/OldEjbRolesUtil", "getEjbRoles"));
        }
        return ejbMethodRoleArray;
    }

    @NotNull
    public static EjbClassRole[] getEjbRoles(PsiClass psiClass) {
        NewEjbRoleHolder roleHolder;
        if (psiClass != null && (roleHolder = NewEjbRoleHolder.getInstance(psiClass.getProject())) != null) {
            EjbClassRole[] ejbClassRoleArray = roleHolder.getMergedRoles(psiClass);
            if (ejbClassRoleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/OldEjbRolesUtil", "getEjbRoles"));
            }
            return ejbClassRoleArray;
        }
        if (EjbClassRoleImpl.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/OldEjbRolesUtil", "getEjbRoles"));
        }
        return EjbClassRoleImpl.EMPTY_ARRAY;
    }

    @NotNull
    public static JavaeeReference[] getInjectedReferences(PsiMember psiMember) {
        PsiClass containingClass = psiMember instanceof PsiClass ? (PsiClass)psiMember : psiMember.getContainingClass();
        Map<PsiMember, JavaeeReference[]> injectedReferencesMap = JavaeeCachesUtil.getJavaeeValue(containingClass, psiMember.getManager(), INJECTED_REFERENCE_PROVIDER_PROVIDER);
        JavaeeReference[] injectedReferences = injectedReferencesMap == null ? null : injectedReferencesMap.get(psiMember);
        JavaeeReference[] javaeeReferenceArray = injectedReferences != null ? injectedReferences : JavaeeReference.EMPTY_ARRAY;
        if (javaeeReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/OldEjbRolesUtil", "getInjectedReferences"));
        }
        return javaeeReferenceArray;
    }

    public static Query[] getMethodQueries(PsiMethod psiMethod) {
        PsiClass containingClass = psiMethod.getContainingClass();
        Map<PsiMethod, Query[]> queryMap = JavaeeCachesUtil.getJavaeeValue((PsiElement)containingClass, QUERY_PROVIDER_PROVIDER, (FacetTypeId<? extends JavaeeFacet>)EjbFacet.ID);
        Query[] queries = queryMap == null ? null : queryMap.get(psiMethod);
        return queries != null ? queries : EMPTY_QUERY_ARRAY;
    }
}

