/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.agent;

import com.intellij.javaee.oss.admin.DeploymentStatusWrapper;
import com.intellij.javaee.oss.agent.AgentDeploymentCallback;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.SimpleAgentException;
import com.intellij.javaee.oss.agent.SimpleAgentJob;
import com.intellij.javaee.oss.agent.VendorSpecificAgentBase;
import com.intellij.javaee.util.ILogger;
import java.io.File;
import java.io.IOException;
import javax.management.JMException;

public abstract class SimpleAgentBase
extends VendorSpecificAgentBase {
    public boolean connect() {
        return (Boolean)new AgentJob<Boolean>(){

            @Override
            protected Boolean doJob() throws IOException, JMException, SimpleAgentException {
                return SimpleAgentBase.this.doConnect();
            }

            @Override
            protected Boolean onException(Exception e) {
                this.getLog().debugEx(e);
                return false;
            }
        }.perform();
    }

    public void startDeploy(final String deploymentName, final File source, final ParametersMap deployParameters, AgentDeploymentCallback callback) {
        new SimpleDeploymentJob(deploymentName, callback){

            protected void doDeploymentJob() throws IOException, JMException, SimpleAgentException {
                SimpleAgentBase.this.doDeploy(deploymentName, source, deployParameters);
            }

            protected DeploymentStatusWrapper getFailStatus() {
                return DeploymentStatusWrapper.STATUS_FAILED;
            }
        }.perform();
    }

    public void startUndeploy(final String deploymentName, AgentDeploymentCallback callback) {
        new SimpleDeploymentJob(deploymentName, callback){

            protected void doDeploymentJob() throws IOException, JMException, SimpleAgentException {
                SimpleAgentBase.this.doUndeploy(deploymentName);
            }

            protected DeploymentStatusWrapper getFailStatus() {
                return DeploymentStatusWrapper.STATUS_UNKNOWN;
            }
        }.perform();
    }

    public void updateDeploymentStatus(String deploymentName, AgentDeploymentCallback callback) {
        new SimpleDeploymentJob(deploymentName, callback){

            protected void doDeploymentJob() {
            }

            protected DeploymentStatusWrapper getFailStatus() {
                return DeploymentStatusWrapper.STATUS_UNKNOWN;
            }
        }.perform();
    }

    protected abstract boolean doConnect() throws IOException, JMException, SimpleAgentException;

    protected abstract void doDeploy(String var1, File var2, ParametersMap var3) throws IOException, JMException, SimpleAgentException;

    protected abstract void doUndeploy(String var1) throws IOException, JMException, SimpleAgentException;

    protected abstract boolean doIsDeployed(String var1) throws IOException, JMException, SimpleAgentException;

    private abstract class SimpleDeploymentJob
    extends DeploymentJob {
        public SimpleDeploymentJob(String deploymentName, AgentDeploymentCallback callback) {
            super(deploymentName, callback);
        }

        protected Void doJob() throws IOException, JMException, SimpleAgentException {
            this.doDeploymentJob();
            this.setDeploymentStatus(SimpleAgentBase.this.doIsDeployed(this.getDeploymentName()) ? DeploymentStatusWrapper.STATUS_DEPLOYED : DeploymentStatusWrapper.STATUS_NOT_DEPLOYED);
            return null;
        }

        protected abstract void doDeploymentJob() throws IOException, JMException, SimpleAgentException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class DeploymentJob
    extends AgentJob<Void> {
        private final String myDeploymentName;
        private final AgentDeploymentCallback myCallback;

        public DeploymentJob(String deploymentName, AgentDeploymentCallback callback) {
            this.myDeploymentName = deploymentName;
            this.myCallback = callback;
        }

        @Override
        protected Void onException(Exception e) {
            this.myCallback.setDeploymentStatusWithError(this.myDeploymentName, this.getFailStatus().getName(), e);
            return null;
        }

        protected void setDeploymentStatus(DeploymentStatusWrapper status) {
            this.myCallback.setDeploymentStatus(this.myDeploymentName, status.getName());
        }

        protected String getDeploymentName() {
            return this.myDeploymentName;
        }

        protected abstract DeploymentStatusWrapper getFailStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AgentJob<T>
    extends SimpleAgentJob<T> {
        protected AgentJob() {
        }

        @Override
        protected ILogger getLog() {
            return SimpleAgentBase.this.getLog();
        }
    }
}

