/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.LoaderContext;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.actions.AssignDataSourcesAction;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JpaDataSourceORMInspection
extends AbstractJpaInspection {
    @NonNls
    public static final String SHORT_NAME = "JpaDataSourceORMInspection";

    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.javaee.persistence.orm.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Override
    protected void checkClassAllRoles(PsiClass aClass, PersistenceClassRole[] roles, ProblemsHolder holder, boolean isOnTheFly) {
        if (ContainerUtil.find((Object[])roles, role -> role.getType() != PersistenceClassRoleEnum.ENTITY_LISTENER) == null) {
            return;
        }
        Processor processor = t -> {
            JpaInspectionUtil.checkMemberAnnotations((PsiModifierListOwner)t, holder, ORMReferencesUtil.DataSourceRelatedReference.class);
            return true;
        };
        JpaInspectionUtil.checkMemberAnnotations((PsiModifierListOwner)aClass, holder, ORMReferencesUtil.DataSourceRelatedReference.class);
        ContainerUtil.process(Arrays.asList(aClass.getFields()), (Processor)processor);
        ContainerUtil.process(Arrays.asList(aClass.getMethods()), (Processor)processor);
    }

    public static LocalQuickFix[] createUnitDataSourceQuickFixes(PersistenceMappings entityMappings) {
        SmartList quickFixes = new SmartList();
        Collection<Object> dataSources = entityMappings == null ? Collections.emptyList() : PersistenceUtil.getDataSources((PersistenceMappings)entityMappings);
        quickFixes.add((Object)new EditUnitDataSourcesQuickFix());
        for (DbDataSource dbDataSource : dataSources) {
            if (!(dbDataSource.getDelegate() instanceof DataSource)) continue;
            quickFixes.add((Object)new RefreshDataSourceQuickFix((LocalDataSource)dbDataSource.getDelegate()));
        }
        return (LocalQuickFix[])quickFixes.toArray((Object[])new LocalQuickFix[quickFixes.size()]);
    }

    private static class EditUnitDataSourcesQuickFix
    implements LocalQuickFix {
        private EditUnitDataSourcesQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = JpaHighlightingMessages.message("fix.edit.unit.datasource.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$EditUnitDataSourcesQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("fix.edit.unit.datasource.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$EditUnitDataSourcesQuickFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$EditUnitDataSourcesQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$EditUnitDataSourcesQuickFix", "applyFix"));
            }
            PersistenceFacet facet = (PersistenceFacet)PersistenceHelper.getHelper().getSharedModelBrowser().queryPersistenceFacets(descriptor.getPsiElement()).findFirst();
            if (facet == null) {
                return;
            }
            AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet);
        }
    }

    private static class RefreshDataSourceQuickFix
    implements LocalQuickFix {
        private final LocalDataSource myDataSource;

        public RefreshDataSourceQuickFix(LocalDataSource dataSource) {
            this.myDataSource = dataSource;
        }

        @NotNull
        public String getName() {
            String string = JpaHighlightingMessages.message("fix.refresh.datasource.name", this.myDataSource.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("fix.refresh.datasource.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jpa/highlighting/JpaDataSourceORMInspection$RefreshDataSourceQuickFix", "applyFix"));
            }
            DataSourceUiUtil.performManualSyncTask((Project)project, (LoaderContext)LoaderContext.loadAll((LocalDataSource)this.myDataSource));
        }
    }
}

