/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.editor;

import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.parser.QlLexer;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class QlSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey KEYWORD = TextAttributesKey.createTextAttributesKey((String)"QL_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"QL_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"QL_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey DATETIME = TextAttributesKey.createTextAttributesKey((String)"QL_DATETIME", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey OP_SIGN = TextAttributesKey.createTextAttributesKey((String)"QL_OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey PARENTHS = TextAttributesKey.createTextAttributesKey((String)"QL_PARENTHS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey COMMA = TextAttributesKey.createTextAttributesKey((String)"QL_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey DOT = TextAttributesKey.createTextAttributesKey((String)"QL_DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey ENTITY = TextAttributesKey.createTextAttributesKey((String)"QL_ENTITY", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
    public static final TextAttributesKey ATTRIBUTE = TextAttributesKey.createTextAttributesKey((String)"QL_ATTRIBUTE", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
    public static final TextAttributesKey ID_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"QL_ID_VARIABLE", (TextAttributesKey)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
    public static final TextAttributesKey FUNCTION = TextAttributesKey.createTextAttributesKey((String)"QL_FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_METHOD);
    public static final TextAttributesKey PARAMETER = TextAttributesKey.createTextAttributesKey((String)"QL_PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
    public static final TextAttributesKey ILLEGAL = TextAttributesKey.createTextAttributesKey((String)"QL_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    private final Language myLanguage;

    public QlSyntaxHighlighter(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "<init>"));
        }
        this.myLanguage = language;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        QlLexer qlLexer = new QlLexer(this.myLanguage);
        if (qlLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getHighlightingLexer"));
        }
        return qlLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType type) {
        if (type == TokenType.BAD_CHARACTER || type == QlLexer.QL_STRING_UNCLOSED) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)ILLEGAL);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_COMMA) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)COMMA);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_DOT) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)DOT);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_STRING) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)STRING);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_NUMBER) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)NUMBER);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (QlLexer.QL_BINARY_OPERATORS.contains(type) || type == QlTypes.QL_QUEST || type == QlTypes.QL_COLON || type == QlTypes.QL_SEMICOLON) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)OP_SIGN);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (type == QlTypes.QL_LEFT_PAREN || type == QlTypes.QL_RIGHT_PAREN || type == QlTypes.QL_LEFT_BRACKET || type == QlTypes.QL_RIGHT_BRACKET) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)PARENTHS);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (QlLexer.getKeywordMap(this.myLanguage).containsKey(type.toString())) {
            TextAttributesKey[] textAttributesKeyArray = QlSyntaxHighlighter.pack((TextAttributesKey)KEYWORD);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/ql/editor/QlSyntaxHighlighter", "getTokenHighlights"));
        }
        return EMPTY;
    }
}

